/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.api;

import com.happysnaker.utils.IOUtil;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class BaiKeApi {
    public static final String api = "https://baike.baidu.com/item/";

    public static Map<String, String> search(String msg) {
        msg = msg.trim();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            URL url = new URL(api + URLEncoder.encode(msg, "UTF-8"));
            String html = IOUtil.sendAndGetResponseString(url, "GET", null, null);
            if (html.contains("\u767e\u5ea6\u767e\u79d1\u9519\u8bef\u9875")) {
                return null;
            }
            Document docDesc = Jsoup.parse(html);
            Elements elements = docDesc.getElementsByAttributeValue("name", "description");
            if (elements.isEmpty()) {
                return null;
            }
            map.put("content", ((Element)elements.get(0)).attr("content"));
            elements = docDesc.getElementsByTag("title");
            if (elements.isEmpty()) {
                return null;
            }
            String text = ((Element)elements.get(0)).text().replace("_\u767e\u5ea6\u767e\u79d1", "").trim();
            int leftIndex = text.indexOf(65288);
            int rightIndex = text.indexOf(65289);
            if (leftIndex != -1 && rightIndex != -1) {
                map.put("title", text.substring(0, leftIndex).trim());
                map.put("desc", text.substring(leftIndex + 1, rightIndex));
            } else {
                map.put("title", text);
                map.put("desc", text);
            }
            elements = docDesc.getElementsByAttributeValue("name", "image");
            if (elements.isEmpty()) {
                return null;
            }
            map.put("image", ((Element)elements.get(0)).attr("content"));
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

