/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.api;

import com.happysnaker.utils.IOUtil;
import com.happysnaker.utils.MapGetter;
import com.happysnaker.utils.StringUtil;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mamoe.mirai.message.data.MusicKind;
import net.mamoe.mirai.message.data.MusicShare;

public class TongZhongApi {
    public static String ok = "ok";
    public static String url1 = "https://music-api.tonzhon.com/song_source/platform/id";
    public static String url2 = "https://tonzhon.com/api/exact_search?keyword=";
    public static String url3 = "https://tonzhon.com/api/fuzzy_search?keyword=";
    public static String url4 = "https://tonzhon.com/secondhand_api/search?platform=qq&keyword=";
    public static String url5 = "https://tonzhon.com/secondhand_api/search?platform=netease&keyword=";
    public static String neteaseJumpUrl = "http://music.163.com/#/song?id=originalId";
    public static String qqJumpUrl = "http://y.qq.com/n/yqq/song/originalId.html";
    public static String kuwoJumpUrl = "http://www.kuwo.cn/yinyue/originalId/";
    public static Map<String, MusicKind> musicKindMap = new HashMap<String, MusicKind>(5);
    public static Map<String, String> jumpMap = new HashMap<String, String>(5);

    public static MusicShare getSongUrl(String keyword) {
        try {
            int i;
            ArrayList<Map<String, Object>> songs = new ArrayList<Map<String, Object>>(TongZhongApi.getSongs(keyword, url2));
            List<Map<String, Object>> s1 = TongZhongApi.getSongs(keyword, url3);
            List<Map<String, Object>> s2 = TongZhongApi.getSongs(keyword, url4);
            List<Map<String, Object>> s3 = TongZhongApi.getSongs(keyword, url5);
            int n = Math.max(Math.max(s1.size(), s2.size()), s3.size());
            for (i = 0; i < n; ++i) {
                if (i < s1.size()) {
                    songs.add(s1.get(i));
                }
                if (i < s2.size()) {
                    songs.add(s2.get(i));
                }
                if (i >= s3.size()) continue;
                songs.add(s3.get(i));
            }
            for (i = 0; i < songs.size(); ++i) {
                ((Map)songs.get(i)).put("index", i);
            }
            songs.sort((a, b) -> {
                int bdis;
                if (a == null || b == null) {
                    return a == null ? 1 : -1;
                }
                String aName = new MapGetter((Map)a).getStringOrDefault("name", "");
                String bName = new MapGetter((Map)b).getStringOrDefault("name", "");
                int adis = StringUtil.getEditDistance(aName.toUpperCase(Locale.ROOT), keyword.toUpperCase(Locale.ROOT));
                if (adis == (bdis = StringUtil.getEditDistance(bName.toUpperCase(Locale.ROOT), keyword.toUpperCase(Locale.ROOT)))) {
                    return (Integer)a.get("index") - (Integer)b.get("index");
                }
                return adis - bdis;
            });
            if (Math.random() <= 0.2) {
                songs.sort((a, b) -> {
                    if (a == null && b == null) {
                        return 0;
                    }
                    return Math.random() <= 0.5 ? 1 : -1;
                });
            }
            for (Map map : songs) {
                try {
                    MapGetter song = new MapGetter(map);
                    String name = song.getString("name");
                    String id = String.valueOf(song.get("originalId"));
                    String platform = song.getString("platform");
                    String url = url1.replace("platform", platform).replace("id", id);
                    MapGetter urlSource = IOUtil.sendAndGetResponseMapGetter(new URL(url), "GET", null, null);
                    String songUrl = urlSource.getMapGetter("data").getString("songSource");
                    if (songUrl == null) continue;
                    String singer = "\u672a\u77e5\u6b4c\u624b";
                    List artists = song.getList("artists");
                    if (artists != null && artists.size() > 0) {
                        singer = new MapGetter(artists.get(0)).getStringOrDefault("name", "\u672a\u77e5\u6b4c\u624b");
                    }
                    return new MusicShare(musicKindMap.get(platform), name, singer + " \u70b9\u51fb\u53f3\u4fa7\u6309\u94ae\u64ad\u653e", jumpMap.get(platform).replace("originalId", id), "http://p2.music.126.net/y19E5SadGUmSR8SZxkrNtw==/109951163785855539.jpg", songUrl);
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static List<Map<String, Object>> getSongs(String keyword, String url) throws Exception {
        Map res = null;
        try {
            res = IOUtil.sendAndGetResponseMap(new URL(url + URLEncoder.encode(keyword, "UTF-8")), "GET", null, null);
        }
        catch (Exception e) {
            return new ArrayList<Map<String, Object>>();
        }
        List songs = null;
        if (!url.equals(url2)) {
            res = (Map)res.get("data");
        }
        if (res != null) {
            songs = res.getOrDefault("songs", null);
        }
        return songs == null ? new ArrayList() : songs;
    }

    static {
        musicKindMap.put("qq", MusicKind.QQMusic);
        musicKindMap.put("netease", MusicKind.NeteaseCloudMusic);
        musicKindMap.put("kuwo", MusicKind.KuwoMusic);
        jumpMap.put("qq", qqJumpUrl);
        jumpMap.put("netease", neteaseJumpUrl);
        jumpMap.put("kuwo", kuwoJumpUrl);
    }
}

