/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import com.happysnaker.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler(priority=1024)
public class AuthorityCommandEventHandler
extends DefaultCommandEventHandlerManager {
    public static final String GRANT_ADMIN = "\u6388\u4e88\u7ba1\u7406\u5458\u6743\u9650";
    public static final String GRANT_GT_ADMIN = "\u6388\u4e88\u574e\u516c\u7ba1\u7406\u5458\u6743\u9650";
    public static final String GRANT_GROUP_ADMIN = "\u6388\u4e88\u7fa4\u7ba1\u7406\u5458\u6743\u9650";
    public static final String SEE_PERMISSION = "\u67e5\u770b\u6743\u9650";
    public static final String REMOVE_ADMIN = "\u79fb\u9664\u7ba1\u7406\u5458\u6743\u9650";
    public static final String REMOVE_GT_ADMIN = "\u79fb\u9664\u574e\u516c\u7ba1\u7406\u5458\u6743\u9650";
    public static final String REMOVE_GROUP_ADMIN = "\u79fb\u9664\u7fa4\u7ba1\u7406\u5458\u6743\u9650";
    public static final Map<Integer, String> permissionMap = new HashMap<Integer, String>();

    public AuthorityCommandEventHandler() {
        super.registerKeywords(GRANT_ADMIN);
        super.registerKeywords(GRANT_GT_ADMIN);
        super.registerKeywords(SEE_PERMISSION);
        super.registerKeywords(REMOVE_GT_ADMIN);
        super.registerKeywords(REMOVE_ADMIN);
        super.registerKeywords(REMOVE_GROUP_ADMIN);
        super.registerKeywords(GRANT_GROUP_ADMIN);
        permissionMap.put(0, "\u8d85\u7ea7\u7ba1\u7406\u5458");
        permissionMap.put(1, "\u666e\u901a\u7ba1\u7406\u5458");
        permissionMap.put(101, "\u574e\u516c\u7ba1\u7406\u5458");
        permissionMap.put(2, "\u7fa4\u7ba1\u7406\u5458");
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        if (content.startsWith(GRANT_ADMIN)) {
            return this.grantAdmin(event);
        }
        if (content.startsWith(GRANT_GT_ADMIN)) {
            return this.grantGtAdmin(event);
        }
        if (content.startsWith(REMOVE_ADMIN)) {
            return this.removeAdmin(event);
        }
        if (content.startsWith(REMOVE_GT_ADMIN)) {
            return this.removeGtAdmin(event);
        }
        if (content.startsWith(SEE_PERMISSION)) {
            return this.seePermission(event);
        }
        if (content.startsWith(GRANT_GROUP_ADMIN)) {
            return this.grantGroupAdmin(event);
        }
        if (content.startsWith(REMOVE_GROUP_ADMIN)) {
            return this.removeGroupAdmin(event);
        }
        return null;
    }

    private List<MessageChain> seePermission(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        String qq = content.replace(SEE_PERMISSION, "").trim();
        if (qq.isEmpty()) {
            qq = AuthorityCommandEventHandler.getSenderId(event);
        } else if (!StringUtil.isNum(qq)) {
            throw new CanNotParseCommandException("\u4e0d\u6b63\u786e\u7684 qq \u683c\u5f0f");
        }
        StringBuilder sb = new StringBuilder();
        for (Integer p : Permission.getPermissionSet(qq)) {
            sb.append("- ").append(permissionMap.get(p)).append("\n");
        }
        return sb.length() == 0 ? AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u7528\u6237 " + qq + " \u65e0\u4efb\u4f55\u6743\u9650") : AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u7528\u6237 " + qq + " \u7684\u6743\u9650\u4e3a:\n" + sb);
    }

    private List<MessageChain> removeGroupAdmin(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        String qq = content.replace(REMOVE_GROUP_ADMIN, "").trim();
        this.assertPermission(AuthorityCommandEventHandler.getSenderId(event), qq, event);
        if (!Permission.hasAdmin(AuthorityCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        if (!RobotConfig.groupAdministrator.contains(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("qq: " + qq + " \u4e0d\u662f\u7fa4\u7ba1\u7406\u5458\uff0c\u6b64\u64cd\u4f5c\u65e0\u4efb\u4f55\u52a8\u4f5c");
        }
        if (RobotConfig.groupAdministrator.remove(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u79fb\u9664\u6210\u529f");
        }
        throw new CanNotParseCommandException("\u672a\u77e5\u9519\u8bef");
    }

    private List<MessageChain> removeGtAdmin(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        String qq = content.replace(REMOVE_GT_ADMIN, "").trim();
        this.assertPermission(AuthorityCommandEventHandler.getSenderId(event), qq, event);
        if (!Permission.hasGroupAdmin(AuthorityCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        if (!RobotConfig.gtAdministrator.contains(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("qq: " + qq + " \u4e0d\u662f\u574e\u516c\u7ba1\u7406\u5458\uff0c\u6b64\u64cd\u4f5c\u65e0\u4efb\u4f55\u52a8\u4f5c");
        }
        if (RobotConfig.gtAdministrator.remove(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u79fb\u9664\u6210\u529f");
        }
        throw new CanNotParseCommandException("\u672a\u77e5\u9519\u8bef");
    }

    private List<MessageChain> removeAdmin(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        String qq = content.replace(REMOVE_ADMIN, "").trim();
        this.assertPermission(AuthorityCommandEventHandler.getSenderId(event), qq, event);
        if (!Permission.hasSuperAdmin(AuthorityCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        if (!RobotConfig.administrator.contains(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("qq: " + qq + " \u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6b64\u64cd\u4f5c\u65e0\u4efb\u4f55\u52a8\u4f5c");
        }
        if (RobotConfig.administrator.remove(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u79fb\u9664\u6210\u529f");
        }
        throw new CanNotParseCommandException("\u672a\u77e5\u9519\u8bef");
    }

    private List<MessageChain> grantGtAdmin(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        String qq = content.replace(GRANT_GT_ADMIN, "").trim();
        this.assertPermission(AuthorityCommandEventHandler.getSenderId(event), qq, event);
        if (!Permission.hasGroupAdmin(AuthorityCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        if (RobotConfig.gtAdministrator.contains(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList(qq + " \u5df2\u662f\u574e\u516c\u7ba1\u7406\u5458");
        }
        RobotConfig.gtAdministrator.add(qq);
        return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u914d\u7f6e\u6210\u529f");
    }

    private List<MessageChain> grantGroupAdmin(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        String qq = content.replace(GRANT_GROUP_ADMIN, "").trim();
        this.assertPermission(AuthorityCommandEventHandler.getSenderId(event), qq, event);
        if (!Permission.hasAdmin(AuthorityCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        if (RobotConfig.groupAdministrator.contains(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList(qq + " \u5df2\u662f\u574e\u516c\u7ba1\u7406\u5458");
        }
        RobotConfig.groupAdministrator.add(qq);
        return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u914d\u7f6e\u6210\u529f");
    }

    private List<MessageChain> grantAdmin(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        String qq = content.replace(GRANT_ADMIN, "").trim();
        this.assertPermission(AuthorityCommandEventHandler.getSenderId(event), qq, event);
        if (!Permission.hasSuperAdmin(AuthorityCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        if (RobotConfig.administrator.contains(qq)) {
            return AuthorityCommandEventHandler.buildMessageChainAsSingletonList(qq + " \u5df2\u662f\u7ba1\u7406\u5458");
        }
        RobotConfig.administrator.add(qq);
        return AuthorityCommandEventHandler.buildMessageChainAsSingletonList("\u914d\u7f6e\u6210\u529f");
    }

    private void assertPermission(String senderQQ, String qq, MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!StringUtil.isNum(qq)) {
            throw new CanNotParseCommandException("\u4e0d\u6b63\u786e\u7684 qq \u683c\u5f0f");
        }
        if (Permission.compare(senderQQ, qq) <= 0) {
            throw new InsufficientPermissionsException();
        }
        if (Permission.hasGroupAdmin(senderQQ) && !Permission.hasAdmin(senderQQ) && !this.getMembersIds(event).contains(Long.valueOf(qq))) {
            throw new InsufficientPermissionsException("\u7fa4\u7ba1\u7406\u5458\u65e0\u6cd5\u8bbe\u7f6e\u4e0d\u5728\u7fa4\u5185\u7684\u5bf9\u8c61");
        }
    }
}

