/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import java.util.List;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler(priority=1024)
public class ColorImageCommandEventHandler
extends DefaultCommandEventHandlerManager {
    public static String openSe = "\u5f00\u542f\u6da9\u56fe";
    public static String closeSe = "\u5173\u95ed\u6da9\u56fe";
    public static String updateSeStrategy = "\u8bbe\u7f6e\u6da9\u56fe\u53d1\u9001\u6a21\u5f0f";

    public ColorImageCommandEventHandler() {
        super.registerKeywords(openSe).registerKeywords(closeSe).registerKeywords(updateSeStrategy);
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        try {
            if (content.equals(openSe)) {
                return this.doOpenSe(event);
            }
            if (content.equals(closeSe)) {
                return this.doCloseSe(event);
            }
            if (content.startsWith(updateSeStrategy)) {
                return this.doUpdateSeStrategy(event);
            }
        }
        catch (InsufficientPermissionsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e);
        }
        return null;
    }

    private List<MessageChain> doOpenSe(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasAdmin(ColorImageCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        RobotConfig.colorSwitch = true;
        return ColorImageCommandEventHandler.buildMessageChainAsSingletonList("\u5df2\u5f00\u542f\u989c\u8272\u56fe\u7247");
    }

    private List<MessageChain> doCloseSe(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasAdmin(ColorImageCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        RobotConfig.colorSwitch = false;
        return ColorImageCommandEventHandler.buildMessageChainAsSingletonList("\u5df2\u5173\u95ed\u989c\u8272\u56fe\u7247");
    }

    private List<MessageChain> doUpdateSeStrategy(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasAdmin(ColorImageCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        int mode = -1;
        try {
            mode = Integer.parseInt(this.getPlantContent(event).replace(updateSeStrategy, ""));
        }
        catch (Exception e) {
            return ColorImageCommandEventHandler.buildMessageChainAsSingletonList("\u65e0\u6cd5\u8bc6\u522b\u7684\u6a21\u5f0f\uff0c\u4ec5\u652f\u6301 0\u30011\u30012\u30013\u30014 \u6a21\u5f0f");
        }
        String message = "\u65e0\u6cd5\u8bc6\u522b\u7684\u6a21\u5f0f\uff0c\u4ec5\u652f\u6301 0\u30011\u30012\u30013 \u6a21\u5f0f";
        switch (mode) {
            case 0: {
                message = "\u5df2\u8bbe\u7f6e\u6a21\u5f0f\uff1a\u4e0d\u53d1\u9001\u4efb\u4f55\u6d88\u606f";
                break;
            }
            case 1: {
                message = "\u5df2\u8bbe\u7f6e\u6a21\u5f0f\uff1a\u4e0a\u4f20\u56fe\u7247\uff0c\u53d1\u9001\u56fe\u7247\u4e0a\u4f20\u94fe\u63a5\u94fe\u63a5";
                break;
            }
            case 2: {
                message = "\u5df2\u8bbe\u7f6e\u6a21\u5f0f\uff1a\u4ec5\u53d1\u9001\u56fe\u7247";
                break;
            }
            case 3: {
                message = "\u5df2\u8bbe\u7f6e\u6a21\u5f0f\uff1a\u5373\u53d1\u9001\u56fe\u7247\uff0c\u4e14\u53d1\u9001\u56fe\u7247\u94fe\u63a5";
                break;
            }
            case 4: {
                message = "\u5df2\u8bbe\u7f6e\u6a21\u5f0f\uff1a\u4ec5\u53d1\u9001\u56fe\u7247\u539f\u59cb\u94fe\u63a5";
            }
        }
        RobotConfig.colorStrategy = 0 <= mode && mode <= 4 ? mode : RobotConfig.colorStrategy;
        return ColorImageCommandEventHandler.buildMessageChainAsSingletonList(ColorImageCommandEventHandler.getQuoteReply(event), message);
    }
}

