/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import com.happysnaker.utils.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;
import org.apache.commons.lang3.StringEscapeUtils;

@handler(priority=1024)
public class CustomKeywordCommandEventHandler
extends DefaultCommandEventHandlerManager {
    public static final String SET_KEYWORD = "\u8bbe\u7f6e\u5173\u952e\u5b57\u56de\u590d";
    public static final String SET_GROUP_KEYWORD = "\u8bbe\u7f6e\u7fa4\u5185\u5173\u952e\u5b57\u56de\u590d";
    public static final String REMOVE_KEYWORD = "\u79fb\u9664\u5173\u952e\u5b57";
    public static final String REMOVE_GROUP_KEYWORD = "\u79fb\u9664\u7fa4\u5185\u5173\u952e\u5b57";
    public static final String CLEAR_KEYWORD = "\u6e05\u7a7a\u5173\u952e\u5b57";
    public static final String CLEAR_GROUP_KEYWORD = "\u6e05\u7a7a\u7fa4\u5185\u5173\u952e\u5b57";
    public static final String CLEAR_ALL = "\u6e05\u7a7a\u6240\u6709\u5173\u952e\u5b57";
    public static final String SEE_GROUP_KEYWORD = "\u67e5\u770b\u7fa4\u5185\u5173\u952e\u5b57";

    public CustomKeywordCommandEventHandler() {
        super.registerKeywords(SET_KEYWORD);
        super.registerKeywords(SET_GROUP_KEYWORD);
        super.registerKeywords(REMOVE_GROUP_KEYWORD);
        super.registerKeywords(REMOVE_KEYWORD);
        super.registerKeywords(CLEAR_KEYWORD);
        super.registerKeywords(CLEAR_GROUP_KEYWORD);
        super.registerKeywords(CLEAR_ALL);
        super.registerKeywords(SEE_GROUP_KEYWORD);
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        if (content.contains(SET_KEYWORD)) {
            return this.setKeyword(event);
        }
        if (content.contains(SET_GROUP_KEYWORD)) {
            return this.setGroupKeyword(event);
        }
        if (content.contains(REMOVE_KEYWORD)) {
            return this.removeKeyword(event);
        }
        if (content.contains(REMOVE_GROUP_KEYWORD)) {
            return this.removeGroupKeyword(event);
        }
        if (content.contains(CLEAR_KEYWORD)) {
            return this.clearKeyword(event);
        }
        if (content.contains(CLEAR_GROUP_KEYWORD)) {
            return this.clearGroupKeyword(event);
        }
        if (content.contains(CLEAR_ALL)) {
            return this.clearAll(event);
        }
        return super.parseCommand(event);
    }

    private List<MessageChain> setKeyword(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasAdmin(CustomKeywordCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        String content = CustomKeywordCommandEventHandler.getContent(event).replace(RobotConfig.commandPrefix + SET_KEYWORD, "").trim();
        Pair<String, String> pair = CustomKeywordCommandEventHandler.hasQuote(event) ? Pair.of(content, CustomKeywordCommandEventHandler.getContent(CustomKeywordCommandEventHandler.getQuoteMessageChain(event))) : this.getKeyVal(content);
        String regexKey = StringEscapeUtils.unescapeJava(pair.getKey());
        RobotConfig.customKeyword.put(regexKey, pair.getValue());
        return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u6dfb\u52a0\u5168\u5c40\u81ea\u5b9a\u4e49\u5173\u952e\u5b57 " + regexKey + " \u53ca\u56de\u590d\u6210\u529f\uff01");
    }

    private List<MessageChain> setGroupKeyword(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasGroupAdmin(CustomKeywordCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u6743\u9650\u4e0d\u8db3");
        }
        String content = CustomKeywordCommandEventHandler.getContent(event).replace(RobotConfig.commandPrefix + SET_GROUP_KEYWORD, "").trim();
        Pair<String, String> pair = CustomKeywordCommandEventHandler.hasQuote(event) ? Pair.of(content, CustomKeywordCommandEventHandler.getContent(CustomKeywordCommandEventHandler.getQuoteMessageChain(event))) : this.getKeyVal(content);
        RobotConfig.customKeyword.putIfAbsent(this.getGroupId(event), new HashMap());
        Map gMap = (Map)RobotConfig.customKeyword.get(this.getGroupId(event));
        gMap.put(pair.getKey(), pair.getValue());
        return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u6dfb\u52a0\u7fa4\u5185\u81ea\u5b9a\u4e49\u5173\u952e\u5b57 " + pair.getKey().replace("#regex#", "") + " \u53ca\u56de\u590d\u6210\u529f\uff01");
    }

    private List<MessageChain> removeKeyword(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasAdmin(CustomKeywordCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        String content = CustomKeywordCommandEventHandler.getContent(event).replace(RobotConfig.commandPrefix + REMOVE_KEYWORD, "").trim();
        if (RobotConfig.customKeyword.remove(content) == null) {
            return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u4e0d\u5305\u542b\u6b64\u5168\u5c40\u5173\u952e\u5b57\uff1a" + content);
        }
        return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u79fb\u9664\u6210\u529f");
    }

    private List<MessageChain> removeGroupKeyword(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasGroupAdmin(CustomKeywordCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        String content = CustomKeywordCommandEventHandler.getContent(event).replace(RobotConfig.commandPrefix + REMOVE_GROUP_KEYWORD, "").trim();
        if (!RobotConfig.customKeyword.containsKey(this.getGroupId(event))) {
            return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u6b64\u7fa4\u6682\u65e0\u4efb\u4f55\u7fa4\u5185\u5173\u952e\u5b57\u914d\u7f6e");
        }
        Map gMap = (Map)RobotConfig.customKeyword.get(this.getGroupId(event));
        if (gMap.remove(content) == null) {
            return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u4e0d\u5305\u542b\u6b64\u7fa4\u5185\u5173\u952e\u5b57\uff1a" + content);
        }
        return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u79fb\u9664\u6210\u529f");
    }

    private List<MessageChain> clearKeyword(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasAdmin(CustomKeywordCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<String> allGroupId = CustomKeywordCommandEventHandler.getBotsAllGroupId();
        for (Map.Entry<String, Object> entry : RobotConfig.customKeyword.entrySet()) {
            if (!allGroupId.contains(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        RobotConfig.customKeyword = map;
        return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u5df2\u6e05\u7a7a\u6240\u6709\u5168\u5c40\u5173\u952e\u5b57");
    }

    private List<MessageChain> clearGroupKeyword(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasGroupAdmin(CustomKeywordCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        RobotConfig.customKeyword.remove(this.getGroupId(event));
        return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u5df2\u6e05\u7a7a\u7fa4 " + this.getGroupId(event) + " \u5185\u7684\u6240\u6709\u5173\u952e\u5b57");
    }

    private List<MessageChain> clearAll(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasSuperAdmin(CustomKeywordCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        RobotConfig.customKeyword = new HashMap<String, Object>();
        return CustomKeywordCommandEventHandler.buildMessageChainAsSingletonList("\u5df2\u6e05\u7a7a\u6240\u6709\u5173\u952e\u5b57\u4fe1\u606f");
    }

    private Pair<String, String> getKeyVal(String content) throws CanNotParseCommandException {
        int l = content.indexOf(123);
        int r = content.indexOf(125);
        if (l == -1 || r == -1) {
            throw new CanNotParseCommandException("\u672a\u68c0\u6d4b\u5230\u5173\u952e\u5b57\uff0c\u8bf7\u4ee5{}\u5305\u88f9\u5173\u952e\u5b57\uff0c\u6ce8\u610f{}\u4e3a\u82f1\u6587\u5b57\u7b26.");
        }
        String keyword = content.substring(l + 1, r);
        if (CustomKeywordCommandEventHandler.getBotsAllGroupId().contains(keyword)) {
            throw new CanNotParseCommandException("\u4e0d\u6b63\u786e\u7684\u5173\u952e\u5b57\u683c\u5f0f\uff0c\u5173\u952e\u5b57\u4e0d\u5f97\u4ee5\u673a\u5668\u4eba\u6240\u6709\u7684\u7fa4\u53f7");
        }
        String val = content.replace("{" + keyword + "}", "");
        return new Pair<String, String>(keyword.trim(), val.trim());
    }
}

