/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.AbstractCommandEventHandler;
import com.happysnaker.config.ConfigManager;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.proxy.Context;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

public class DefaultCommandEventHandlerManager
extends AbstractCommandEventHandler
implements Serializable {
    protected Set<String> keywords = new HashSet<String>();
    private static StringBuilder log = new StringBuilder();
    private static int successNum = 0;

    protected DefaultCommandEventHandlerManager registerKeywords(String kw) {
        this.keywords.add(kw);
        return this;
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        throw new CanNotParseCommandException();
    }

    protected static void flush() {
        log = new StringBuilder();
        successNum = 0;
    }

    @Override
    public void success(MessageEvent event) {
        if (super.getPlantContent(event).startsWith("\u67e5\u770b")) {
            return;
        }
        log.append(ConfigManager.formatLog(event)).append("\n");
        ++successNum;
    }

    @Override
    public void fail(MessageEvent event, String errorMsg) {
        this.logError(event, errorMsg);
    }

    protected String checkLogStatus() {
        return successNum > 0 ? log.toString() : null;
    }

    public static int getSuccessNum() {
        return successNum;
    }

    @Override
    public boolean shouldHandle(MessageEvent event, Context ctx) {
        String content;
        if (this.keywords == null || this.keywords.isEmpty()) {
            return false;
        }
        if (super.shouldHandle(event, ctx) && (content = this.getPlantContent(event)) != null) {
            for (String keyword : this.keywords) {
                if (!content.startsWith(keyword)) continue;
                return true;
            }
        }
        return false;
    }
}

