/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import com.happysnaker.utils.OfUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler(priority=1024)
public class GroupManageCommandEventHandler
extends DefaultCommandEventHandlerManager {
    @Deprecated
    public static final String ENABLE_AUTO_APPROVE = "\u5f00\u542f\u81ea\u52a8\u5ba1\u6279";
    @Deprecated
    public static final String DISABLE_AUTO_APPROVE = "\u5173\u95ed\u81ea\u52a8\u5ba1\u6279";
    public static final String ENABLE_SENSITIVE_WORD_DETECTION = "\u5f00\u542f\u654f\u611f\u8bcd\u68c0\u6d4b";
    public static final String DISABLE_SENSITIVE_WORD_DETECTION = "\u5173\u95ed\u654f\u611f\u8bcd\u68c0\u6d4b";

    public GroupManageCommandEventHandler() {
        this.registerKeywords(ENABLE_AUTO_APPROVE);
        this.registerKeywords(DISABLE_AUTO_APPROVE);
        this.registerKeywords(ENABLE_SENSITIVE_WORD_DETECTION);
        this.registerKeywords(DISABLE_SENSITIVE_WORD_DETECTION);
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasAdmin(GroupManageCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u6743\u9650\u4e0d\u8db3");
        }
        try {
            String content = super.getPlantContent(event);
            String gid = this.getGroupId(event);
            if (content.startsWith(DISABLE_AUTO_APPROVE)) {
                ArrayList<Map<String, String>> copy = new ArrayList<Map<String, String>>(RobotConfig.autoApproval);
                for (Map map : copy) {
                    if (!map.containsKey(this.getGroupId(event))) continue;
                    RobotConfig.autoApproval.remove(map);
                }
                return GroupManageCommandEventHandler.buildMessageChainAsSingletonList("\u5173\u95ed\u81ea\u52a8\u5ba1\u6279\u6210\u529f");
            }
            if (content.startsWith(ENABLE_AUTO_APPROVE)) {
                String s = content.replaceFirst(ENABLE_AUTO_APPROVE, "").trim();
                RobotConfig.autoApproval.add(OfUtil.ofMap(gid, s));
                return GroupManageCommandEventHandler.buildMessageChainAsSingletonList("\u5f00\u542f\u81ea\u52a8\u5ba1\u6279\u6210\u529f\uff0c\u5ba1\u6279\u9a8c\u8bc1\u6d88\u606f\uff1a" + s);
            }
            if (content.startsWith(ENABLE_SENSITIVE_WORD_DETECTION)) {
                if (!RobotConfig.enableSensitiveWordDetection.contains(gid)) {
                    RobotConfig.enableSensitiveWordDetection.add(gid);
                }
                return GroupManageCommandEventHandler.buildMessageChainAsSingletonList("\u672c\u7fa4\u5df2\u5f00\u542f\u654f\u611f\u8bcd\u68c0\u6d4b");
            }
            if (content.startsWith(DISABLE_SENSITIVE_WORD_DETECTION)) {
                RobotConfig.enableSensitiveWordDetection.remove(gid);
                return GroupManageCommandEventHandler.buildMessageChainAsSingletonList("\u672c\u7fa4\u5df2\u5173\u95ed\u654f\u611f\u8bcd\u68c0\u6d4b");
            }
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e);
        }
        return null;
    }
}

