/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;

@handler(priority=1024)
@Deprecated
public class GtCommandEventHandler
extends DefaultCommandEventHandlerManager {
    public static final String addGtMembersCommand = "\u6dfb\u52a0\u574e\u516c\u516c\u4f1a\u6210\u5458";
    public static final String clearGtMembersCommand = "\u6e05\u7a7a\u574e\u516c\u516c\u4f1a\u6210\u5458";
    public static final String setGtMembersCommand = "\u8bbe\u7f6e\u574e\u516c\u516c\u4f1a\u6210\u5458";
    public static final String seeGtMembersCommand = "\u67e5\u770b\u574e\u516c\u516c\u4f1a\u6210\u5458";
    public static final String removeGtMembersCommand = "\u79fb\u9664\u574e\u516c\u516c\u4f1a\u6210\u5458";
    public static final String setGtCookieCommand = "\u8bbe\u7f6e\u574e\u516ccookie";

    public GtCommandEventHandler() {
        super.registerKeywords(setGtCookieCommand);
        super.registerKeywords(setGtMembersCommand);
        super.registerKeywords(seeGtMembersCommand);
        super.registerKeywords(removeGtMembersCommand);
        super.registerKeywords(clearGtMembersCommand);
        super.registerKeywords(addGtMembersCommand);
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        ArrayList<MessageChain> ans = new ArrayList<MessageChain>();
        String content = this.getPlantContent(event);
        try {
            if (content.startsWith(setGtMembersCommand)) {
                ans.add(this.doSetGtMembers(event));
            } else if (content.startsWith(setGtCookieCommand)) {
                ans.add(this.doSetGtCookie(event));
            } else if (content.startsWith(seeGtMembersCommand)) {
                ans.add(this.doSeeGtMembers(event));
            } else if (content.startsWith(removeGtMembersCommand)) {
                ans.add(this.doRemoveGtMembers(event));
            } else if (content.startsWith(clearGtMembersCommand)) {
                ans.add(this.doClearGtMembers(event));
            } else if (content.startsWith(addGtMembersCommand)) {
                ans.add(this.doAddGtMembers(event));
            }
        }
        catch (InsufficientPermissionsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e);
        }
        return ans;
    }

    public MessageChain doAddGtMembers(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasGtAdmin(GtCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        List<String> gtMembers = this.getGtMembers(event);
        HashSet<String> book = new HashSet<String>(gtMembers);
        if (gtMembers == null || gtMembers.isEmpty()) {
            return GtCommandEventHandler.buildMessageChain("\u8be5\u7fa4\u6682\u672a\u914d\u7f6e\u6210\u5458\u4fe1\u606f\uff0c\u65e0\u6cd5\u6dfb\u52a0\u6210\u5458\uff0c\u8bf7\u5148\u914d\u7f6e\u3002\n\u9ed8\u8ba4\u5c06\u6240\u6709\u7fa4\u6210\u5458\u89c6\u4e3a\u516c\u4f1a\u6210\u5458\u3002");
        }
        String content = this.getPlantContent(event).replace(addGtMembersCommand, "").trim();
        String[] strings = content.split("\\s+");
        int num = 0;
        for (String string : strings) {
            if (book.contains(string)) continue;
            gtMembers.add(string);
            ++num;
        }
        this.addIfAbsent(this.getGroupId(event), "members", gtMembers);
        return GtCommandEventHandler.buildMessageChain("\u914d\u7f6e\u6210\u529f\uff0c\u65b0\u589e\u6210\u5458\u6570 " + num);
    }

    public MessageChain doClearGtMembers(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasGtAdmin(GtCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        List<String> gtMembers = this.getGtMembers(event);
        if (gtMembers == null || gtMembers.isEmpty()) {
            return GtCommandEventHandler.buildMessageChain("\u8be5\u7fa4\u6682\u672a\u914d\u7f6e\u6210\u5458\u4fe1\u606f\uff0c\u65e0\u6cd5\u6e05\u7a7a\u6210\u5458\uff0c\u8bf7\u5148\u914d\u7f6e\u3002\n\u9ed8\u8ba4\u5c06\u6240\u6709\u7fa4\u6210\u5458\u89c6\u4e3a\u516c\u4f1a\u6210\u5458\u3002");
        }
        this.addIfAbsent(this.getGroupId(event), "members", new ArrayList());
        return GtCommandEventHandler.buildMessageChain("\u6e05\u7a7a\u6210\u529f");
    }

    public MessageChain doRemoveGtMembers(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasGtAdmin(GtCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        String content = this.getPlantContent(event).replace(removeGtMembersCommand, "").trim();
        String[] strings = content.split("\\s+");
        List<String> gtMembers = this.getGtMembers(event);
        if (gtMembers == null || gtMembers.isEmpty()) {
            return GtCommandEventHandler.buildMessageChain("\u8be5\u7fa4\u6682\u672a\u914d\u7f6e\u6210\u5458\u4fe1\u606f\uff0c\u65e0\u6cd5\u79fb\u9664\u6210\u5458\uff0c\u8bf7\u5148\u914d\u7f6e\u3002\n\u9ed8\u8ba4\u5c06\u6240\u6709\u7fa4\u6210\u5458\u89c6\u4e3a\u516c\u4f1a\u6210\u5458\u3002");
        }
        int num = 0;
        for (String string : strings) {
            if (!gtMembers.remove(string)) continue;
            ++num;
        }
        this.addIfAbsent(this.getGroupId(event), "members", gtMembers);
        System.out.println("num = " + num);
        return GtCommandEventHandler.buildMessageChain("\u79fb\u9664\u6210\u5458\u6210\u529f\uff0c\u5171\u79fb\u9664 " + num + " \u540d\u6210\u5458");
    }

    public MessageChain doSeeGtMembers(MessageEvent event) throws InsufficientPermissionsException {
        System.out.println("Permission.hasGtAdmin(getSenderId(event)) = " + Permission.hasGtAdmin(GtCommandEventHandler.getSenderId(event)));
        if (!Permission.hasGtAdmin(GtCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        HashSet<String> groupNames = new HashSet<String>(this.getMembersGroupName(event));
        List<String> gtMembers = this.getGtMembers(event);
        StringBuilder sb = new StringBuilder("\u7fa4 " + this.getGroupId(event) + " \u7684\u5de5\u4f1a\u6210\u5458\u914d\u7f6e\u4e3a\uff1a\n");
        int num = 0;
        if (gtMembers != null || gtMembers.isEmpty()) {
            for (String gtMember : gtMembers) {
                sb.append("- " + gtMember);
                if (!groupNames.contains(gtMember)) {
                    sb.append(" (\u7fa4\u5185\u672a\u68c0\u6d4b\u5230\u8be5\u6210\u5458)");
                    ++num;
                }
                sb.append("\n");
            }
        } else {
            sb.append("\u5f53\u524d\u7fa4\u65e0\u5de5\u4f1a\u6210\u5458\u914d\u7f6e\uff0c\u9ed8\u8ba4\u5c06\u5168\u90e8\u7fa4\u6210\u5458\u89c6\u4e3a\u516c\u4f1a\u6210\u5458");
        }
        if (num > 0) {
            sb.append("\u6709 " + num + " \u540d\u6210\u5458\u672a\u5728\u7fa4\u5185\u68c0\u6d4b\u5230\uff0c\u50ac\u5200\u65f6\u53ef\u80fd\u65e0\u6cd5\u641c\u5bfb\u5230\u8fd9\u4e9b\u73a9\u5bb6\uff0c\u82e5\u60f3\u66f4\u597d\u7684\u4f7f\u7528\u6b64\u529f\u80fd\uff0c\u8bf7\u7763\u4fc3\u8fd9\u4e9b\u73a9\u5bb6\u66f4\u6539\u7fa4\u540d\u7247\u4e3a\u6e38\u620f\u540d\u79f0");
        }
        return GtCommandEventHandler.buildMessageChain(sb.toString());
    }

    public MessageChain doSetGtCookie(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasAdmin(GtCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        String content = this.getPlantContent(event).replace(RobotConfig.commandPrefix, "");
        content = content.trim();
        String[] strs = content.trim().split("\\s+");
        String groupId = strs[1];
        String cookie = strs[2];
        for (int i = 2; i < strs.length; ++i) {
            if (strs[i].isEmpty()) continue;
            cookie = cookie + strs[i];
        }
        this.addIfAbsent(groupId, "gtCookie", cookie);
        return GtCommandEventHandler.buildMessageChain("\u914d\u7f6e\u6210\u529f\uff0c\u6ce8\u610f\u5982\u679c\u4e0d\u6267\u884c\u4fdd\u5b58\u914d\u7f6e\u547d\u4ee4\uff0c\u914d\u7f6e\u5c06\u4f1a\u5728\u673a\u5668\u4eba\u91cd\u542f\u65f6\u5931\u6548\u3002");
    }

    public MessageChain doSetGtMembers(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasGtAdmin(GtCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException();
        }
        String content = this.getPlantContent(event);
        String[] members = content.replace(setGtMembersCommand, "").trim().split("\\s+");
        if (members == null || members.length == 0) {
            return new MessageChainBuilder().append((CharSequence)"\u672a\u68c0\u6d4b\u5230\u4efb\u4f55\u6210\u5458\u4fe1\u606f").build();
        }
        List m = Arrays.stream(members).collect(Collectors.toList());
        this.addIfAbsent(this.getGroupId(event), "members", m);
        return GtCommandEventHandler.buildMessageChain("\u914d\u7f6e\u6210\u529f\uff01");
    }

    private void addIfAbsent(String gid, String key, Object val) {
        for (Map<String, Object> map : RobotConfig.gtConfig) {
            String groupId = (String)map.getOrDefault("groupId", "");
            if (!groupId.equals(gid.trim())) continue;
            map.put(key, val);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("groupId", gid);
        map.put(key, val);
        RobotConfig.gtConfig.add(map);
    }

    private List<String> getGtMembers(MessageEvent event) {
        String gid = this.getGroupId(event);
        for (Map<String, Object> map : RobotConfig.gtConfig) {
            if (!map.getOrDefault("groupId", "").equals(gid)) continue;
            return map.getOrDefault("members", new ArrayList());
        }
        return new ArrayList<String>();
    }
}

