/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import com.happysnaker.utils.OfUtil;
import com.happysnaker.utils.Pair;
import com.happysnaker.utils.RobotUtil;
import java.util.Collections;
import java.util.List;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler(priority=1024)
public class PeriodCommandEventHandler
extends DefaultCommandEventHandlerManager {
    public static final String ADD_PERIOD_TASK = "\u8bbe\u7f6e\u5b9a\u65f6\u4efb\u52a1";

    public PeriodCommandEventHandler() {
        this.registerKeywords(ADD_PERIOD_TASK);
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasAdmin(PeriodCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u6743\u9650\u4e0d\u8db3");
        }
        try {
            String content = PeriodCommandEventHandler.getContent(event).replace(RobotConfig.commandPrefix + ADD_PERIOD_TASK, "").trim();
            Pair<String, String> keyVal = this.getKeyVal(content);
            String[] split = keyVal.getKey().split("-");
            int hour = Integer.parseInt(split[0]);
            int minute = Integer.parseInt(split[1]);
            int count = Integer.parseInt(split[2]);
            int image = split.length == 4 ? Integer.parseInt(split[3]) : 0;
            RobotConfig.periodicTask.add(OfUtil.ofMap(OfUtil.ofList("hour", "minute", "groupId", "count", "image", "content"), OfUtil.ofList(hour, minute, this.getGroupId(event), 0, image == 1, keyVal.getValue())));
            MessageChain message = PeriodCommandEventHandler.parseMiraiCode(keyVal.getValue(), event);
            Contact contact = event.getSubject();
            RobotUtil.submitSendRandomMsgTask(hour, minute, count <= 0 ? Integer.MAX_VALUE : count, Collections.singletonList(PeriodCommandEventHandler.getContent(message)), contact);
            return PeriodCommandEventHandler.buildMessageChainAsSingletonList("\u4efb\u52a1\u63d0\u4ea4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e.getMessage());
        }
    }

    private Pair<String, String> getKeyVal(String content) throws CanNotParseCommandException {
        int l = content.indexOf(123);
        int r = content.indexOf(125);
        if (l == -1 || r == -1) {
            throw new CanNotParseCommandException("\u672a\u68c0\u6d4b\u5230\u5173\u952e\u5b57\uff0c\u8bf7\u4ee5{}\u5305\u88f9\u5173\u952e\u5b57\uff0c\u65e5\u671f\u683c\u5f0f\u4e3a hour-minute-count-image");
        }
        String keyword = content.substring(l + 1, r);
        String val = content.replace("{" + keyword + "}", "");
        return new Pair<String, String>(keyword.trim(), val.trim());
    }
}

