/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.cron.BilibiliSubscribeCronJob;
import com.happysnaker.cron.RobotCronJob;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import com.happysnaker.utils.MapGetter;
import com.happysnaker.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler(priority=1024)
public class SubscribeCommandEventHandler
extends DefaultCommandEventHandlerManager {
    public static final String SUBSCRIBE_COMMAND = "\u8ba2\u9605";

    public SubscribeCommandEventHandler() {
        super.registerKeywords(SUBSCRIBE_COMMAND);
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        if (!Permission.hasGroupAdmin(SubscribeCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u6ca1\u6709\u8db3\u591f\u7684\u6743\u9650");
        }
        String content = this.getPlantContent(event);
        List<String> strings = StringUtil.splitSpaces(content);
        if (strings.size() < 4) {
            return SubscribeCommandEventHandler.buildMessageChainAsSingletonList("\u8ba2\u9605\u547d\u4ee4\u683c\u5f0f: #\u8ba2\u9605 \u5e73\u53f0 \u7c7b\u578b ID At\u6210\u5458\u5217\u8868");
        }
        try {
            if (strings.get(1).equals("bilibili")) {
                int type = Integer.parseInt(strings.get(2));
                if (type < 0 || type > 1) {
                    return SubscribeCommandEventHandler.buildMessageChainAsSingletonList("\u4e0d\u5408\u6cd5\u7684\u7c7b\u578b\uff0c\u4ec5\u652f\u6301 0 \u6216 1");
                }
                long groupId = Long.parseLong(this.getGroupId(event));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("platform", "bilibili");
                map.put("type", type);
                map.put("key", strings.get(3));
                map.put("atMembers", strings.subList(4, strings.size()));
                map.put("pushGroup", groupId);
                RobotConfig.subscribe.add(map);
                BilibiliSubscribeCronJob cronJob = new BilibiliSubscribeCronJob(new MapGetter(map));
                RobotCronJob.addCronTask(cronJob);
            }
            return SubscribeCommandEventHandler.buildMessageChainAsSingletonList(String.format("\u8ba2\u9605 %s \u6210\u529f", strings.get(3)));
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e);
        }
    }
}

