/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.command.impl;

import com.happysnaker.command.impl.DefaultCommandEventHandlerManager;
import com.happysnaker.config.ConfigManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.permission.Permission;
import com.happysnaker.starter.HRobotStarter;
import java.util.List;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler(priority=1024)
public class SystemCommandEventHandler
extends DefaultCommandEventHandlerManager {
    public static String reloadConfigCommand = "\u91cd\u8f7d\u914d\u7f6e";
    public static String saveConfigCommand = "\u4fdd\u5b58\u914d\u7f6e";
    public static String showConfigStatusCommand = "\u67e5\u770b\u914d\u7f6e\u72b6\u6001";
    public static String showConfigLogCommand = "\u67e5\u770b\u914d\u7f6e\u65e5\u5fd7";
    public static String shutdown = "\u5173\u673a";
    public static String boot = "\u5f00\u673a";

    public SystemCommandEventHandler() {
        super.registerKeywords(saveConfigCommand);
        super.registerKeywords(showConfigStatusCommand);
        super.registerKeywords(showConfigLogCommand);
        super.registerKeywords(reloadConfigCommand);
        super.registerKeywords(shutdown).registerKeywords(boot);
    }

    @Override
    public List<MessageChain> parseCommand(MessageEvent event) throws CanNotParseCommandException, InsufficientPermissionsException {
        String content = this.getPlantContent(event);
        try {
            if (content.equals(saveConfigCommand)) {
                return this.doSaveConfig(event);
            }
            if (content.equals(showConfigStatusCommand)) {
                return this.doShowConfigStatusCommand(event);
            }
            if (content.equals(showConfigLogCommand)) {
                return this.doShowConfigLogCommand(event);
            }
            if (content.equals(reloadConfigCommand)) {
                return this.doReloadConfigCommand(event);
            }
            if (content.equals(shutdown)) {
                return this.doShutDown(event);
            }
            if (content.equals(boot)) {
                return this.doBoot(event);
            }
        }
        catch (InsufficientPermissionsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e);
        }
        return null;
    }

    private List<MessageChain> doShutDown(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasSuperAdmin(SystemCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        RobotConfig.enableRobot = false;
        return SystemCommandEventHandler.buildMessageChainAsSingletonList("\u8d70\u5566\uff0c\u671f\u5f85\u4e0b\u6b21\u89c1\u9762!");
    }

    private List<MessageChain> doBoot(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasSuperAdmin(SystemCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        RobotConfig.enableRobot = true;
        return SystemCommandEventHandler.buildMessageChainAsSingletonList("\u6211\u53c8\u56de\u6765\u4e86\uff01");
    }

    public List<MessageChain> doReloadConfigCommand(MessageEvent event) throws InsufficientPermissionsException, CanNotParseCommandException {
        if (!Permission.hasAdmin(SystemCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        try {
            HRobotStarter.initRobotConfig(null);
            return SystemCommandEventHandler.buildMessageChainAsSingletonList("\u91cd\u8f7d\u6210\u529f!");
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e);
        }
    }

    public List<MessageChain> doShowConfigLogCommand(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasAdmin(SystemCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        String log = this.checkLogStatus();
        return log == null ? SystemCommandEventHandler.buildMessageChainAsSingletonList("\u6682\u65e0\u65e5\u5fd7") : SystemCommandEventHandler.buildMessageChainAsSingletonList(log);
    }

    public List<MessageChain> doShowConfigStatusCommand(MessageEvent event) throws InsufficientPermissionsException {
        if (!Permission.hasAdmin(SystemCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        int num = SystemCommandEventHandler.getSuccessNum();
        return num == 0 ? SystemCommandEventHandler.buildMessageChainAsSingletonList("The command tree is clean now") : SystemCommandEventHandler.buildMessageChainAsSingletonList("There are " + num + " command successfully be done\uff0cit may be dirty now, try to check the log!");
    }

    public List<MessageChain> doSaveConfig(MessageEvent event) throws InsufficientPermissionsException, CanNotParseCommandException {
        if (!Permission.hasAdmin(SystemCommandEventHandler.getSenderId(event))) {
            throw new InsufficientPermissionsException("\u60a8\u7684\u6743\u9650\u4e0d\u8db3\uff0c\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c");
        }
        try {
            ConfigManager.writeConfig();
            SystemCommandEventHandler.flush();
        }
        catch (Exception e) {
            throw new CanNotParseCommandException(e);
        }
        return SystemCommandEventHandler.buildMessageChainAsSingletonList("\u914d\u7f6e\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

