/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.config;

import com.happysnaker.config.Logger;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.utils.OfUtil;
import com.happysnaker.utils.RobotUtil;
import com.happysnaker.utils.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    public static Set<String> systemConfig = OfUtil.ofSet("CURRENT_VERSION", "mainConfigPathName", "sensitiveWordPathName", "configFolder", "dataFolder", "logger");
    @Deprecated
    public static List<String> configNames = OfUtil.ofList("administrator", "gtAdministrator", "groupAdministrator", "menu", "gtConfig", "include", "exclude", "pictureWithdrawalTime", "customKeywordSimilarity", "customKeyword", "commandPrefix", "timeout", "duChickenSoupProbability", "enableAt", "replyReplace", "autoApproval", "skipIsMeaninglessWord", "withdrawalThreshold", "enableSensitiveWordDetection", "skipStep", "periodicTask", "colorSwitch", "russianRoulette", "colorStrategy", "subscribe", "logLevel");
    public static String TEMPLATE = "";

    public static void recordFailLog(MessageEvent event, String errorMsg) {
        String message = ConfigManager.formatLog(event) + "\n\u9519\u8bef\u65e5\u5fd7\uff1a" + errorMsg + "\n\n";
        try {
            Logger.logErrorAndRecord(message);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatLog(MessageEvent event) {
        if (event == null) {
            return "[" + StringUtil.formatTime() + "]";
        }
        String content = RobotUtil.getContent(event);
        String sender = RobotUtil.getSenderId(event);
        if (!(event instanceof GroupMessageEvent)) {
            return "[sender:" + sender + "-" + StringUtil.formatTime() + "] -> " + content;
        }
        long groupId = ((GroupMessageEvent)event).getGroup().getId();
        return "[sender:" + sender + " - group:" + groupId + " - " + StringUtil.formatTime() + "] -> " + content;
    }

    public static String getConfigFilePath() {
        return RobotConfig.configFolder + "/" + RobotConfig.mainConfigPathName;
    }

    public static String getConfigFilePath(String fileName) {
        return RobotConfig.configFolder + "/" + fileName;
    }

    public static String getDataFilePath(String fileName) {
        return RobotConfig.dataFolder + "/" + fileName;
    }

    public static Map<String, Object> getConfigMap() {
        try {
            Field[] fields = RobotConfig.class.getDeclaredFields();
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields) {
                if (systemConfig.contains(field.getName())) continue;
                map.put(field.getName(), field.get(null));
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized void writeConfig() throws Exception {
        File file = new File(ConfigManager.getConfigFilePath());
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            new Yaml().dump(new TreeMap<String, Object>(ConfigManager.getConfigMap()), new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        }
    }

    static {
        InputStream inputStream = ConfigManager.class.getClassLoader().getResourceAsStream("config/config_template.yaml");
        try {
            assert (inputStream != null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                TEMPLATE = TEMPLATE + line + "\n";
            }
            TEMPLATE = TEMPLATE.replace("$CURRENT_VERSION", "3.4.1");
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            RobotConfig.logger.info("\u914d\u7f6e\u6587\u4ef6\u6a21\u677f\u5199\u5165\u6709\u8bef\uff0c\u8bf7\u624b\u52a8\u7f16\u5199\u914d\u7f6e\u6587\u4ef6\uff0c\u53ef\u53c2\u8003 Github \u4e2d\u7684\u914d\u7f6e\u6a21\u677f");
            System.exit(1);
        }
    }
}

