/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.cron;

import com.happysnaker.api.BilibiliApi;
import com.happysnaker.cron.SubscribeCronJob;
import com.happysnaker.entry.BilibiliDynamic;
import com.happysnaker.exception.FileUploadException;
import com.happysnaker.utils.MapGetter;
import com.happysnaker.utils.RobotUtil;
import com.happysnaker.utils.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.MessageChain;

public class BilibiliSubscribeCronJob
extends SubscribeCronJob {
    public BilibiliSubscribeCronJob(long pushGroup, List<String> atMembers, int type, String key) {
        super(pushGroup, atMembers, type, key);
    }

    public BilibiliSubscribeCronJob(MapGetter mapGetter) {
        super(mapGetter);
    }

    @Override
    public MessageChain doCheckAndPush(Contact contact) throws IOException, FileUploadException {
        return this.type == 1 ? this.checkFanDrama(contact) : this.checkUpDynamic(contact);
    }

    private MessageChain checkFanDrama(Contact contact) throws IOException, FileUploadException {
        BilibiliDynamic dynamic = BilibiliApi.getLatestFanDrama(this.key);
        if (dynamic == null || dynamic.pubTime <= this.lastPubTime) {
            return null;
        }
        String sb = String.format("\u60a8\u8ba2\u9605\u7684\u756a\u5267 %s \u66f4\u65b0\u5566\n", dynamic.getAuthName()) + String.format("\u66f4\u65b0\u65f6\u95f4\uff1a%s\n", StringUtil.formatTime(dynamic.getPubTime())) + String.format("\u8df3\u8f6c\u94fe\u63a5\uff1a%s\n", dynamic.getJumpUrl()) + String.format("\u66f4\u65b0\u7ae0\u8282\uff1a%s\n", dynamic.getDesc()) + String.format("\u5206\u4eab\u63cf\u8ff0\uff1a%s\n", dynamic.getPubAction());
        this.lastPubTime = dynamic.pubTime;
        if (StringUtil.isNullOrEmpty(dynamic.face) && StringUtil.isNullOrEmpty(dynamic.cover)) {
            return RobotUtil.buildMessageChain(sb);
        }
        Image face = RobotUtil.uploadImage(contact, new URL(dynamic.face));
        Image cover = RobotUtil.uploadImage(contact, new URL(dynamic.cover));
        return RobotUtil.buildMessageChain(sb, face, cover);
    }

    private MessageChain checkUpDynamic(Contact contact) throws IOException, FileUploadException {
        BilibiliDynamic dynamic = BilibiliApi.getLatestDynamic(this.key);
        assert (dynamic != null);
        if (dynamic.pubTime <= this.lastPubTime) {
            return null;
        }
        String sb = String.format("\u60a8\u8ba2\u9605\u7684 up \u4e3b %s %s\n", dynamic.getAuthName(), dynamic.getPubAction()) + String.format("\u66f4\u65b0\u65f6\u95f4\uff1a%s\n", StringUtil.formatTime(dynamic.getPubTime())) + String.format("\u8df3\u8f6c\u94fe\u63a5\uff1a%s\n", dynamic.getJumpUrl()) + String.format("\u63cf\u8ff0\u5185\u5bb9\uff1a%s\n", dynamic.getDesc());
        Image face = RobotUtil.uploadImage(contact, new URL(dynamic.face));
        Image cover = null;
        if (!StringUtil.isNullOrEmpty(dynamic.cover)) {
            cover = RobotUtil.uploadImage(contact, new URL(dynamic.cover));
        }
        this.lastPubTime = dynamic.pubTime;
        return RobotUtil.buildMessageChain(sb, face, cover);
    }
}

