/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.cron;

import com.happysnaker.config.ConfigManager;
import com.happysnaker.config.Logger;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.utils.RobotUtil;
import com.happysnaker.utils.StringUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.SingleMessage;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;

public class PeriodCronJob
implements Job {
    public static final String KEY = "KEY_PeriodCronJobData";

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (!RobotConfig.enableRobot) {
            return;
        }
        PeriodCronJobData jobData = (PeriodCronJobData)context.getJobDetail().getJobDataMap().get(KEY);
        Logger.info("\u6267\u884c\u7528\u6237\u914d\u7f6e\u5b9a\u671f\u53d1\u9001\u6d88\u606f\u4efb\u52a1\uff1a" + context.getJobDetail().getKey() + "\uff0c\u5f53\u524d\u65f6\u95f4\uff1a" + new Date() + "\uff0c\u4e0b\u4e00\u6b21\u6267\u884c\u65f6\u95f4\uff1a" + context.getNextFireTime() + "\uff0c\u5269\u4f59\u6b21\u6570 " + jobData.count.get());
        if (jobData.count.get() <= 0) {
            Logger.info(String.format("\u4efb\u52a1 %s \u6267\u884c\u6b21\u6570\u5df2\u8fbe\u9608\u503c\uff0c\u53d6\u6d88\u4efb\u52a1", context.getJobDetail().getKey()));
            try {
                context.getScheduler().deleteJob(context.getJobDetail().getKey());
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
        try {
            if (jobData.rawMessages != null && !jobData.rawMessages.isEmpty()) {
                jobData.messages = new ArrayList<MessageChain>();
                String rawMessage = jobData.rawMessages.get((int)((double)jobData.rawMessages.size() * Math.random()));
                jobData.messages.add(RobotUtil.parseMiraiCode(rawMessage, jobData.contact));
            }
            if (jobData.messages == null || jobData.messages.isEmpty()) {
                Logger.debug("\u6ca1\u6709\u4efb\u4f55\u6d88\u606f\u9700\u8981\u53d1\u9001\uff0c\u5ffd\u7565\u672c\u6b21\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u914d\u7f6e\u4e86\u7a7a\u6d88\u606f\u6216\u8005\u65e0\u6cd5\u89e3\u6790\u7684\u8bed\u4e49");
                return;
            }
            Message message = (Message)jobData.messages.get((int)((double)jobData.messages.size() * Math.random()));
            if (jobData.plusImage) {
                message = message.plus((SingleMessage)RobotUtil.uploadImage(jobData.contact, new URL("https://api.vvhan.com/api/acgimg")));
            }
            jobData.contact.sendMessage(message);
            Logger.debug(String.format("\u4efb\u52a1 %s \u6267\u884c\u5b8c\u6bd5\uff0c\u5269\u4f59\u6b21\u6570\uff1a%d", context.getJobDetail().getKey(), jobData.count.decrementAndGet()));
        }
        catch (Exception e) {
            e.printStackTrace();
            ConfigManager.recordFailLog(null, StringUtil.getErrorInfoFromException(e));
        }
    }

    public static class PeriodCronJobData {
        public volatile AtomicInteger count;
        public volatile List<MessageChain> messages;
        public volatile List<String> rawMessages;
        public volatile Contact contact;
        @Deprecated
        public volatile boolean plusImage;

        @Deprecated
        public PeriodCronJobData(int count, boolean plusImage, List<MessageChain> messages, Contact contact) {
            this.count = new AtomicInteger(count);
            this.messages = messages;
            this.contact = contact;
            this.plusImage = plusImage;
        }

        public PeriodCronJobData(int count, List<String> messages, Contact contact) {
            this.count = new AtomicInteger(count);
            this.rawMessages = messages;
            this.contact = contact;
        }

        @Deprecated
        public static JobDataMap getJobDataMap(int count, boolean plusImage, List<MessageChain> messages, Contact contact) {
            PeriodCronJobData jobData = new PeriodCronJobData(count, plusImage, messages, contact);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put(PeriodCronJob.KEY, (Object)jobData);
            return jobDataMap;
        }

        public static JobDataMap getJobDataMap(int count, List<String> messages, Contact contact) {
            PeriodCronJobData jobData = new PeriodCronJobData(count, messages, contact);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put(PeriodCronJob.KEY, (Object)jobData);
            return jobDataMap;
        }
    }
}

