/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.cron;

import com.happysnaker.config.Logger;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.cron.BilibiliSubscribeCronJob;
import com.happysnaker.cron.SubscribeCronJob;
import com.happysnaker.exception.CanNotParseCommandException;
import com.happysnaker.utils.MapGetter;
import com.happysnaker.utils.RobotUtil;
import com.happysnaker.utils.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class RobotCronJob
implements Job {
    public static volatile CopyOnWriteArrayList<Runnable> tasks = new CopyOnWriteArrayList();
    @Deprecated
    public static volatile Timer service = new Timer();
    public static volatile Scheduler scheduler;
    public static Set<Long> visited;
    public static final int PERIOD_MINUTE = 3;

    public static List<SubscribeCronJob> parseSubscribeCronJobFromConfig() throws CanNotParseCommandException {
        ArrayList<SubscribeCronJob> ret = new ArrayList<SubscribeCronJob>();
        for (Map<String, Object> sub : RobotConfig.subscribe) {
            MapGetter mg = new MapGetter(sub);
            if ("bilibili".equals(mg.getString("platform", true))) {
                ret.add(new BilibiliSubscribeCronJob(mg));
                continue;
            }
            throw new CanNotParseCommandException("\u65e0\u6cd5\u89e3\u6790\u7684\u914d\u7f6e");
        }
        return ret;
    }

    public static void cron() throws Exception {
        RobotCronJob.submitCronJob(RobotCronJob.class, SimpleScheduleBuilder.repeatMinutelyForever(3), null);
        RobotCronJob.addCronTask(RobotCronJob.parseSubscribeCronJobFromConfig());
    }

    public static void runCustomerPeriodTask(Bot instance) throws Exception {
        if (visited.contains(instance.getId())) {
            return;
        }
        visited.add(instance.getId());
        for (Map<String, Object> map : RobotConfig.periodicTask) {
            MapGetter mg = new MapGetter(map);
            long gid = mg.getLong("groupId");
            int count = mg.getInt("count") <= 0 ? Integer.MAX_VALUE : mg.getInt("count");
            boolean plusImage = mg.getBoolean("image");
            Contact contact = instance.getGroups().getOrFail(gid);
            List<String> messages = mg.getListOrWrapperSingleton("content", String.class);
            if (plusImage) {
                messages = messages.stream().map(str -> String.format("%s\n[hrobot::$img](%s)", str, "https://api.vvhan.com/api/acgimg")).collect(Collectors.toList());
            }
            if (instance.getGroups().contains(gid)) {
                if (!StringUtil.isNullOrEmpty(mg.getString("cron"))) {
                    RobotUtil.submitSendRandomMsgTask(mg.getString("cron"), count, messages, contact);
                    continue;
                }
                RobotUtil.submitSendRandomMsgTask(mg.getInt("hour"), mg.getInt("minute"), count, messages, contact);
                continue;
            }
            RobotConfig.logger.info(String.format("\u672a\u68c0\u6d4b\u5230\u5b9a\u65f6\u4efb\u52a1\u63a8\u9001\u7fa4\u53f7 %s", gid));
        }
    }

    public static void submitCronJob(Class<? extends Job> c, ScheduleBuilder<? extends Trigger> scheduleBuilder, JobDataMap data) throws SchedulerException {
        if (data == null) {
            data = new JobDataMap();
        }
        JobDetail jobDetail = JobBuilder.newJob(c).usingJobData(data).build();
        Trigger trigger = TriggerBuilder.newTrigger().startNow().withSchedule(scheduleBuilder).build();
        scheduler.scheduleJob(jobDetail, trigger);
        Logger.info(String.format("\u63d0\u4ea4\u4e00\u6761\u4efb\u52a1 %s\uff0c\u4e0b\u4e00\u6b21\u6267\u884c\u65f6\u95f4 %s", jobDetail.getKey().toString(), trigger.getNextFireTime().toString()));
    }

    public static void addCronTask(Runnable task) {
        tasks.add(task);
    }

    public static void addCronTask(List<? extends Runnable> tasks) {
        RobotCronJob.tasks.addAll(tasks);
    }

    public static void rmCronTask(Runnable task) {
        tasks.remove(task);
    }

    @Override
    public void execute(JobExecutionContext context) {
        try {
            if (!RobotConfig.enableRobot) {
                return;
            }
            Logger.debug(new Date() + ", run robot cron job...");
            for (Runnable task : tasks) {
                task.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        visited = new HashSet<Long>();
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
            try {
                TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            scheduler.start();
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }
}

