/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.cron;

import com.happysnaker.config.ConfigManager;
import com.happysnaker.config.Logger;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.FileUploadException;
import com.happysnaker.utils.MapGetter;
import com.happysnaker.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.AtAll;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.SingleMessage;

public abstract class SubscribeCronJob
implements Runnable {
    public long pushGroup;
    public List<String> atMembers;
    public int type;
    public String key;
    public volatile long lastPubTime;

    public SubscribeCronJob(long pushGroup, List<String> atMembers, int type, String key) {
        this.pushGroup = pushGroup;
        this.atMembers = atMembers;
        this.type = type;
        this.key = key;
        this.lastPubTime = System.currentTimeMillis();
        if (atMembers == null) {
            this.atMembers = new ArrayList<String>();
        }
    }

    public SubscribeCronJob(MapGetter mapGetter) {
        this(mapGetter.getLong("pushGroup"), mapGetter.getListOrWrapperSingleton("atMembers", String.class), mapGetter.getInt("type"), mapGetter.getString("key"));
    }

    @Override
    public void run() {
        Bot instance;
        if (!RobotConfig.enableRobot) {
            return;
        }
        Logger.debug("\u673a\u5668\u4eba\u540e\u53f0\u8ba2\u9605\u68c0\u6d4b\u4efb\u52a1\u5f00\u59cb\u8fd0\u884c");
        Group contact = null;
        if (Bot.getInstances().isEmpty()) {
            Logger.debug("\u672a\u68c0\u67e5\u5230\u4efb\u4f55 Bot \u767b\u5f55\uff0c\u5ffd\u7565\u6b64\u6b21\u8ba2\u9605\u68c0\u6d4b");
            return;
        }
        Iterator iterator = Bot.getInstances().iterator();
        while (iterator.hasNext() && (contact = (instance = (Bot)iterator.next()).getGroup(this.pushGroup)) == null) {
        }
        if (contact == null) {
            Logger.debug(String.format("\u5728\u673a\u5668\u4eba\u597d\u53cb\u5185\u672a\u68c0\u67e5\u5f85\u63a8\u9001\u7fa4\u7ec4\uff0c\u8bf7\u68c0\u67e5\u63a8\u9001\u7fa4\u53f7 %s \u662f\u5426\u6b63\u786e", this.pushGroup));
            return;
        }
        try {
            MessageChain message = null;
            message = this.doCheckAndPush((Contact)contact);
            if (message == null) {
                return;
            }
            MessageChainBuilder builder = new MessageChainBuilder();
            for (String atMember : this.atMembers) {
                if (atMember.equals("-1")) {
                    builder.add((SingleMessage)AtAll.INSTANCE);
                    continue;
                }
                builder.add((SingleMessage)new At(Long.parseLong(atMember)));
            }
            if (!builder.isEmpty()) {
                builder.add("\n");
            }
            builder.add((Message)message);
            contact.sendMessage((Message)builder.build());
        }
        catch (Exception e) {
            ConfigManager.recordFailLog(null, new Date() + ": \u540e\u53f0\u4efb\u52a1\u63a8\u9001\u8ba2\u9605\u6d88\u606f\u5931\u8d25 \n" + StringUtil.getErrorInfoFromException(e));
        }
    }

    public abstract MessageChain doCheckAndPush(Contact var1) throws IOException, FileUploadException;

    public String toString() {
        return "SubscribeCronJob{pushGroup=" + this.pushGroup + ", atMembers=" + this.atMembers + ", type=" + this.type + ", key='" + this.key + '\'' + ", lastPubTime=" + this.lastPubTime + '}';
    }
}

