/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.handler.impl;

import com.happysnaker.config.ConfigManager;
import com.happysnaker.config.Logger;
import com.happysnaker.handler.MessageEventHandler;
import com.happysnaker.proxy.Context;
import com.happysnaker.utils.RobotUtil;
import com.happysnaker.utils.StringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

public abstract class AbstractMessageEventHandler
extends RobotUtil
implements MessageEventHandler,
Serializable {
    public void info(String msg) {
        Logger.debug(msg);
    }

    public void debug(String msg) {
        Logger.debug(msg);
    }

    public void error(String msg) {
        Logger.error(msg);
    }

    public void logError(MessageEvent event, String msg) {
        ConfigManager.recordFailLog(event, msg);
    }

    public void logError(MessageEvent event, Throwable e) {
        ConfigManager.recordFailLog(event, StringUtil.getErrorInfoFromException(e));
    }

    public String getPlantContent(MessageEvent event) {
        return AbstractMessageEventHandler.getOnlyPlainContent(event);
    }

    public boolean startWithKeywords(MessageEvent event, Collection<String> keywords) {
        String content = this.getPlantContent(event);
        if (content != null) {
            for (String keyword : keywords) {
                if (!content.startsWith(keyword)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract List<MessageChain> handleMessageEvent(MessageEvent var1, Context var2);
}

