/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.handler.impl;

import com.happysnaker.config.RobotConfig;
import com.happysnaker.handler.handler;
import com.happysnaker.handler.impl.GroupMessageEventHandler;
import com.happysnaker.proxy.Context;
import com.happysnaker.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.naming.CannotProceedException;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler(priority=0)
public class CustomKeywordMessageEventHandler
extends GroupMessageEventHandler {
    public static final String REGEX_PREFIX = "#regex#";

    @Override
    public List<MessageChain> handleMessageEvent(MessageEvent event, Context ctx) {
        try {
            return CustomKeywordMessageEventHandler.buildMessageChainAsList(CustomKeywordMessageEventHandler.parseMiraiCode(ctx.getMessage(), event));
        }
        catch (CannotProceedException e) {
            this.logError(event, StringUtil.getErrorInfoFromException(e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean shouldHandle(MessageEvent event, Context ctx) {
        String reply;
        Map<String, Object> keywordConfig = RobotConfig.customKeyword;
        if (CustomKeywordMessageEventHandler.getBotsAllGroupId().contains(CustomKeywordMessageEventHandler.getContent(event))) {
            return false;
        }
        String gid = this.getGroupId(event);
        if (keywordConfig.containsKey(gid) && (reply = this.checkSimilarWordAndGetVal((Map)keywordConfig.get(gid), CustomKeywordMessageEventHandler.getContent(event))) != null) {
            ctx.setMessage(reply);
            return true;
        }
        reply = this.checkSimilarWordAndGetVal(keywordConfig, CustomKeywordMessageEventHandler.getContent(event));
        if (reply != null) {
            ctx.setMessage(reply);
            return true;
        }
        return false;
    }

    private String checkSimilarWordAndGetVal(Map<String, Object> map, String word) {
        Object ret = null;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (key.startsWith(REGEX_PREFIX)) {
                if (!Pattern.matches(key = key.replace(REGEX_PREFIX, ""), word)) continue;
                ret = val;
                break;
            }
            int len = key.length();
            double maximumEditDistance = (1.0 - RobotConfig.customKeywordSimilarity) * (double)len;
            if (!((double)StringUtil.getEditDistance(key, word) <= maximumEditDistance)) continue;
            ret = val;
            break;
        }
        if (ret != null) {
            if (ret instanceof List) {
                List list = (List)ret;
                return (String)list.get((int)(Math.random() * (double)list.size()));
            }
            return (String)ret;
        }
        return null;
    }
}

