/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.handler.impl;

import com.happysnaker.api.QingYunKeApi;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.InsufficientPermissionsException;
import com.happysnaker.handler.handler;
import com.happysnaker.handler.impl.AbstractMessageEventHandler;
import com.happysnaker.proxy.Context;
import com.happysnaker.utils.OfUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.ContactList;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.SingleMessage;

@handler(priority=-1)
public class GroupMessageEventHandler
extends AbstractMessageEventHandler {
    protected String getGroupId(MessageEvent event) {
        GroupMessageEvent group = (GroupMessageEvent)event;
        return String.valueOf(group.getGroup().getId());
    }

    protected boolean isGroupMessageEvent(MessageEvent event) {
        return event instanceof GroupMessageEvent;
    }

    protected boolean isAt(MessageEvent event, String qq) {
        for (SingleMessage message : event.getMessage()) {
            if (!(message instanceof At)) continue;
            At at = (At)message;
            if (Long.parseLong(qq) != at.getTarget()) continue;
            return true;
        }
        return false;
    }

    protected boolean isAtBot(MessageEvent event) {
        for (Bot bot : Bot.getInstances()) {
            if (!this.isAt(event, String.valueOf(bot.getId()))) continue;
            return true;
        }
        return false;
    }

    protected GroupMessageEvent getGroupMessageEvent(MessageEvent event) {
        try {
            return (GroupMessageEvent)event;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ContactList<NormalMember> getMembers(MessageEvent event) {
        GroupMessageEvent group = this.getGroupMessageEvent(event);
        if (group != null) {
            return group.getGroup().getMembers();
        }
        return null;
    }

    protected List<String> getMembersGroupName(MessageEvent event) {
        ContactList<NormalMember> members = null;
        ArrayList<String> ans = new ArrayList<String>();
        members = this.getMembers(event);
        if (members != null) {
            for (NormalMember member : members) {
                String s = member.getNameCard();
                if (s.isEmpty()) {
                    s = member.queryProfile().getNickname();
                }
                ans.add(s);
            }
        }
        return ans;
    }

    protected List<Long> getMembersIds(MessageEvent event) {
        ContactList<NormalMember> members = null;
        ArrayList<Long> ans = new ArrayList<Long>();
        members = this.getMembers(event);
        if (members != null) {
            for (NormalMember member : members) {
                member.getNameCard();
                ans.add(member.getId());
            }
        }
        return ans;
    }

    protected Long getMemberIdByName(MessageEvent event, String groupName) {
        long ans = -1L;
        ContactList<NormalMember> members = this.getMembers(event);
        if (members != null) {
            for (NormalMember member : members) {
                String s = member.getNameCard();
                if (s.isEmpty()) {
                    s = member.queryProfile().getNickname();
                }
                if (!s.equals(groupName)) continue;
                return member.getId();
            }
        }
        return ans;
    }

    @Override
    public List<MessageChain> handleMessageEvent(MessageEvent event, Context ctx) {
        String content = this.getPlantContent(event);
        String help1 = "\u5e2e\u52a9";
        String help2 = "help";
        String help3 = "\u83dc\u5355";
        if (help1.equals(content) || help2.equals(content) || help3.equals(content)) {
            if (!RobotConfig.menu.isEmpty()) {
                return GroupMessageEventHandler.buildMessageChainAsSingletonList(RobotConfig.menu);
            }
            return GroupMessageEventHandler.buildMessageChainAsSingletonList("\u6682\u672a\u914d\u7f6e\u76f8\u5173\u4fe1\u606f\uff0c\u8bf7\u5373\u4f7f\u914d\u7f6e");
        }
        return OfUtil.ofList(GroupMessageEventHandler.replaceFaceFromContent(QingYunKeApi.getMessage(content)));
    }

    @Override
    public String getPlantContent(MessageEvent event) {
        return super.getPlantContent(event).trim();
    }

    protected int getSenderPermission(MessageEvent event) {
        MemberPermission permission = this.getGroupMessageEvent(event).getPermission();
        return permission.getLevel();
    }

    @Override
    public boolean shouldHandle(MessageEvent event, Context ctx) {
        return this.isGroupMessageEvent(event) && (this.isAtBot(event) || !RobotConfig.enableAt);
    }

    protected boolean cancelMessage(MessageSource source) {
        try {
            MessageSource.recall((MessageSource)source);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean cancelMessage(MessageEvent event) throws InsufficientPermissionsException {
        if (((GroupMessageEvent)event).getPermission().getLevel() > 0) {
            throw new InsufficientPermissionsException("\u6743\u9650\u4e0d\u8db3");
        }
        return this.cancelMessage((MessageSource)event.getSource());
    }

    @Override
    public boolean startWithKeywords(MessageEvent event, Collection<String> keywords) {
        return this.isGroupMessageEvent(event) && super.startWithKeywords(event, keywords);
    }

    protected void mute(String qq, Group group, int durationSecond) {
        for (NormalMember member : group.getMembers()) {
            if (member.getId() != Long.parseLong(qq)) continue;
            member.mute(durationSecond);
            return;
        }
    }

    protected void muteSend(MessageEvent event, int durationSecond) {
        this.getGroupMessageEvent(event).getSender().mute(durationSecond);
    }
}

