/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.handler.impl;

import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.FileUploadException;
import com.happysnaker.handler.handler;
import com.happysnaker.handler.impl.GroupMessageEventHandler;
import com.happysnaker.proxy.Context;
import com.happysnaker.utils.ChartUtil;
import com.happysnaker.utils.IOUtil;
import com.happysnaker.utils.NumUtil;
import com.happysnaker.utils.OfUtil;
import com.happysnaker.utils.Pair;
import com.happysnaker.utils.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.SingleMessage;

@handler(priority=1)
@Deprecated
public class GtReportMessageEventHandler
extends GroupMessageEventHandler {
    public static final String BATTLE_REPORT = "\u4f1a\u6218\u62a5\u8868";
    public static final String FRONTLINE_REPORTING = "\u524d\u7ebf\u62a5\u9053";
    public static final String BATTLE_STATISTICS = "\u4f1a\u6218\u7edf\u8ba1";
    public static final String WHO_NOT_SHOOT1 = "\u8c01\u672a\u51fa\u5200";
    public static final String WHO_NOT_SHOOT2 = "\u8c01\u6ca1\u51fa\u5200";
    public static final String URGE_KNIFE = "\u50ac\u5200";
    public static final String URGE_KNIFE_ALL = "\u4e00\u952e\u50ac\u5200";
    public static final String CHECK_KNIFE = "\u67e5\u5200";
    private static final String BATTLE_REPORT_URL = "https://www.bigfun.cn/api/feweb?target=kan-gong-guild-report%2Fa&date=";
    public static final String FRONTLINE_REPORTING_URL = "https://www.bigfun.cn/api/feweb?target=kan-gong-guild-boss-info%2Fa";
    public static final String GET_MEMBER_URL = "https://www.bigfun.cn/api/feweb?target=kan-gong-guild-log-filter/a";
    private Set<String> keywords = new HashSet<String>(16);
    public static final int TOTAL_COUNT = 3;
    public static final String DATA = "data";
    public static final String USER_NAME = "user_name";
    public static final String DAMAGE_TOTAL = "damage_total";
    public static final String DAMAGE_LIST = "damage_list";
    public static final String DAMAGE = "damage";
    public static final String BOSS_NAME = "boss_name";
    public static final String IS_KILL = "is_kill";
    public static final String BOSS = "boss";
    public static final String LEVEL = "level";
    public static final String TOTAL_HP = "total_hp";
    public static final String REMAIN_HP = "remain_hp";
    public static final String NAME = "name";
    public static final String TYPE = "elemental_type_cn";

    public GtReportMessageEventHandler() {
        this.keywords.add(BATTLE_REPORT);
        this.keywords.add(FRONTLINE_REPORTING);
        this.keywords.add(BATTLE_STATISTICS);
        this.keywords.add(WHO_NOT_SHOOT1);
        this.keywords.add(WHO_NOT_SHOOT2);
        this.keywords.add(URGE_KNIFE);
        this.keywords.add(URGE_KNIFE_ALL);
        this.keywords.add(CHECK_KNIFE);
    }

    @Override
    public List<MessageChain> handleMessageEvent(MessageEvent event, Context ctx) {
        String cookie = this.getCookie(this.getGroupId(event));
        if (cookie != null && !cookie.isEmpty()) {
            String content = this.getPlantContent(event);
            try {
                if (content.contains(BATTLE_REPORT)) {
                    return OfUtil.ofList(this.doParseBattleReport(cookie));
                }
                if (content.contains(FRONTLINE_REPORTING)) {
                    return OfUtil.ofList(this.doParseFrontlineReporting(cookie));
                }
                if (content.contains(BATTLE_STATISTICS)) {
                    if (content.equals(BATTLE_STATISTICS)) {
                        return OfUtil.ofList(this.doParseBattleStatistics(cookie));
                    }
                    return OfUtil.ofList(this.doParseBattleStatistics(cookie, content.replace(BATTLE_STATISTICS, "").trim(), event));
                }
                if (content.contains(WHO_NOT_SHOOT1) || content.contains(WHO_NOT_SHOOT2)) {
                    return OfUtil.ofList(this.doParseCheck(cookie, event));
                }
                if (content.contains(URGE_KNIFE_ALL)) {
                    Pair<Set<String>, Set<String>> pair = this.getNotDoPeople(cookie, event);
                    Set<String> param = pair.getKey();
                    param.addAll((Collection<String>)pair.getValue());
                    return OfUtil.ofList(this.doUrge(event, param));
                }
                if (content.contains(URGE_KNIFE)) {
                    return OfUtil.ofList(this.doUrge(event, this.getNotDoPeople(cookie, event).getKey()));
                }
                if (content.contains(CHECK_KNIFE)) {
                    return this.check(event, cookie);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logError(event, e);
                return OfUtil.ofList(new MessageChainBuilder().append((CharSequence)"\u53d1\u751f\u4e86\u4e00\u6761\u610f\u6599\u4e4b\u5916\u7684\u9519\u8bef").build());
            }
        }
        return OfUtil.ofList(new MessageChainBuilder().append((CharSequence)"\u8be5\u7fa4\u6682\u672a\u914d\u7f6e\u76f8\u5173\u4fe1\u606f").build());
    }

    public List<MessageChain> check(MessageEvent event, String cookie) throws IOException, FileUploadException {
        String content = this.getPlantContent(event).replace(CHECK_KNIFE, "").trim();
        boolean testLine = false;
        if (content.startsWith("\u6298\u7ebf\u56fe")) {
            content = content.replace("\u6298\u7ebf\u56fe", "").trim();
            testLine = true;
        }
        List<String> ms = StringUtil.splitSpaces(content);
        Map<String, Object> msg = null;
        List dates = (List)((Map)IOUtil.sendAndGetResponseMap(new URL(GET_MEMBER_URL), "GET", this.getHeaders(cookie), null).get(DATA)).get("date");
        ArrayList<Pair<String, List<Pair<String, Double>>>> datasets = new ArrayList<Pair<String, List<Pair<String, Double>>>>();
        HashMap map = new HashMap();
        Collections.reverse(dates);
        for (String date : dates) {
            msg = IOUtil.sendAndGetResponseMap(new URL(BATTLE_REPORT_URL + date), "GET", this.getHeaders(cookie), null);
            List datas = msg.getOrDefault(DATA, new ArrayList());
            HashSet<String> doneSet = new HashSet<String>();
            for (Map data : datas) {
                String username = (String)data.get(USER_NAME);
                doneSet.add(username);
                List damageList = (List)data.get(DAMAGE_LIST);
                map.putIfAbsent(username, new ArrayList());
                if (damageList != null) {
                    if (damageList.size() == 3) {
                        ((List)map.get(username)).add(Pair.of(date, 3.0));
                        continue;
                    }
                    ((List)map.get(username)).add(Pair.of(date, Double.valueOf(damageList.size())));
                    continue;
                }
                ((List)map.get(username)).add(Pair.of(date, 0.1));
            }
            for (String m : ms) {
                map.putIfAbsent(m, new ArrayList());
                if (doneSet.contains(m)) continue;
                ((List)map.get(m)).add(Pair.of(date, 0.1));
            }
        }
        for (String m : ms) {
            if (!m.contains(m)) continue;
            datasets.add(Pair.of(m, (List)map.get(m)));
        }
        String f = testLine ? ChartUtil.generateALineChart(datasets, CHECK_KNIFE, "\u65e5\u671f", "\u51fa\u5200\u6570") : ChartUtil.generateHistogram(datasets, CHECK_KNIFE, "\u65e5\u671f", "\u51fa\u5200\u6570");
        return GtReportMessageEventHandler.buildMessageChainAsSingletonList(GtReportMessageEventHandler.uploadImage(event, f));
    }

    private String getMostDamageUser(Map<String, Object> data, String bossName) {
        long d = 0L;
        String ans = "";
        for (Map.Entry<String, Object> it : data.entrySet()) {
            Map map = (Map)it.getValue();
            long dmg = ((Map)map.getOrDefault(bossName, new HashMap())).getOrDefault("totalDamage", 0L);
            if (dmg <= d) continue;
            d = dmg;
            ans = it.getKey();
        }
        return ans;
    }

    private String getCookie(String groupId) {
        List<Map<String, Object>> gtConfigs = RobotConfig.gtConfig;
        String cookie = null;
        for (Map<String, Object> gtConfig : gtConfigs) {
            String gid = gtConfig.getOrDefault("groupId", null);
            if (gid != null && !gid.isEmpty() && !gid.equals(groupId)) continue;
            cookie = gtConfig.getOrDefault("gtCookie", null);
            break;
        }
        return cookie;
    }

    public Pair<Map<String, Object>, Set<String>> getParseBattleStatisticsMap(String cookie) throws Exception {
        String numberOfCuts = "count";
        String totalDamage = "totalDamage";
        List<String> dates = Collections.unmodifiableList((List)((Map)IOUtil.sendAndGetResponseMap(new URL(GET_MEMBER_URL), "GET", this.getHeaders(cookie), null).get(DATA)).get("date"));
        HashSet<String> bossNames = new HashSet<String>(4);
        HashMap<String, Map> memberData = new HashMap<String, Map>();
        for (String date : dates) {
            Map<String, Object> msg = null;
            msg = IOUtil.sendAndGetResponseMap(new URL(BATTLE_REPORT_URL + date), "GET", this.getHeaders(cookie), null);
            if (msg.getOrDefault("message", "").equals("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")) break;
            List data = msg.getOrDefault(DATA, new ArrayList());
            for (Map dat : data) {
                String userName = (String)dat.get(USER_NAME);
                List damageList = (List)dat.get(DAMAGE_LIST);
                Map member = memberData.getOrDefault(userName, new HashMap());
                long count = 0L;
                long tot = 0L;
                for (Map damage : damageList) {
                    String bossName = (String)damage.get(BOSS_NAME);
                    bossNames.add(bossName);
                    long dmg = NumUtil.objectToLong(damage.get(DAMAGE));
                    Map bossMap = member.getOrDefault(bossName, new HashMap());
                    bossMap.put(numberOfCuts, bossMap.getOrDefault(numberOfCuts, 0L) + 1L);
                    bossMap.put(totalDamage, bossMap.getOrDefault(totalDamage, 0L) + dmg);
                    member.put(bossName, bossMap);
                    ++count;
                    tot += dmg;
                }
                member.put(numberOfCuts, member.getOrDefault(numberOfCuts, 0L) + count);
                member.put(totalDamage, member.getOrDefault(totalDamage, 0L) + tot);
                memberData.put(userName, member);
            }
        }
        return new Pair<Map<String, Object>, Set<String>>(memberData, bossNames);
    }

    public MessageChain doUrge(MessageEvent event, Set<String> names) {
        if (names == null || names.isEmpty()) {
            return GtReportMessageEventHandler.buildMessageChain("\u6682\u65e0\u672a\u51fa\u5200\u6210\u5458\uff0c\u8d5e\uff01");
        }
        MessageChainBuilder builder = new MessageChainBuilder();
        for (String name : names) {
            Long id = this.getMemberIdByName(event, name);
            if (id <= 0L) continue;
            At at = new At(id.longValue());
            builder.add((SingleMessage)at);
        }
        builder.add("\n\u8fd8\u4e0d\u8d76\u5feb\u53bb\u6253\u516c\u4f1a\u6218\uff01\n\n\u6ce8\uff1a\u5982\u672a\u914d\u7f6e\u516c\u4f1a\u6210\u5458\uff0c\u6b64\u884c\u4e3a\u4f1a\u5c06\u7fa4\u5185\u6240\u6709\u6210\u5458\u89c6\u4e3a\u516c\u4f1a\u6210\u5458\uff0c\u8fd9\u53ef\u80fd\u4f1a\u5bfc\u81f4\u591a\u4f59@\uff0c\u5982\u5df2\u914d\u7f6e\uff0c\u8bf7\u4fdd\u8bc1\u516c\u4f1a\u6210\u5458\u540d\u79f0\u5b8c\u5168\u7b49\u4e8e\u7fa4\u6635\u79f0");
        return builder.build();
    }

    public MessageChain doParseCheck(String cookie, MessageEvent event) {
        Pair<Set<String>, Set<String>> pair = this.getNotDoPeople(cookie, event);
        StringBuilder sb = new StringBuilder();
        sb.append("\u4ee5\u4e0b\u7528\u6237\u6682\u672a\u51fa\u5200\uff1a\n");
        if (pair.getKey().size() != 0) {
            for (String s : pair.getKey()) {
                sb.append("  -" + s + "\n");
            }
        }
        sb.append("\u672a\u51fa\u5200\u7528\u6237\u603b\u6570\uff1a" + pair.getKey().size() + "\n\n");
        sb.append("\u4ee5\u4e0b\u7528\u6237\u51fa\u4e86\u5200\uff0c\u4f46\u672a\u51fa\u6ee1\u4e09\u5200\uff1a\n");
        if (pair.getValue().size() != 0) {
            for (String s : pair.getValue()) {
                sb.append("  -" + s + "\n");
            }
        }
        sb.append("\u51fa\u4e86\u5200\u4f46\u672a\u51fa\u6ee1\u5200\u7684\u7528\u6237\u603b\u6570\uff1a" + pair.getValue().size() + "\n\n");
        sb.append("\u6ce8\uff1a\u672c\u529f\u80fd\u4f7f\u7528\u7684\u524d\u63d0\u662f\u73a9\u5bb6\u6e38\u620f\u5185\u7528\u6237\u540d\u5fc5\u987b\u5b8c\u5168\u7b49\u4e8eQQ\u7fa4\u5185\u540d\u79f0\uff0c\u5426\u5219\u65e0\u6548");
        return new MessageChainBuilder().append((CharSequence)sb.toString()).build();
    }

    private Set<String> getGtMembers(MessageEvent event) {
        String groupId = this.getGroupId(event);
        for (Map<String, Object> map : RobotConfig.gtConfig) {
            String id = map.getOrDefault("groupId", null);
            if (id == null || !id.equals(groupId)) continue;
            if (!map.containsKey("members") || ((List)map.get("members")).isEmpty()) {
                return null;
            }
            return new HashSet<String>((List)map.get("members"));
        }
        return null;
    }

    public Pair<Set<String>, Set<String>> getNotDoPeople(String cookie, MessageEvent event) {
        Set<String> members = this.getGtMembers(event);
        if (members == null) {
            members = new HashSet<String>(this.getMembersGroupName(event));
        }
        Map<String, Object> msg = null;
        try {
            msg = IOUtil.sendAndGetResponseMap(new URL(BATTLE_REPORT_URL), "GET", this.getHeaders(cookie), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet<String> s = new HashSet<String>();
        HashSet<String> s1 = new HashSet<String>();
        HashSet<String> s2 = new HashSet<String>();
        List datas = msg.getOrDefault(DATA, new ArrayList());
        for (Map data : datas) {
            String username = (String)data.get(USER_NAME);
            List damageList = (List)data.get(DAMAGE_LIST);
            if (damageList == null) continue;
            if (damageList.size() == 3) {
                s.add(username);
                continue;
            }
            s2.add(username);
        }
        for (String member : members) {
            if (s.contains(member) || s2.contains(member)) continue;
            s1.add(member);
        }
        return new Pair<Set<String>, Set<String>>(s1, s2);
    }

    public MessageChain doParseBattleStatistics(String cookie, String username, MessageEvent event) throws IOException, FileUploadException {
        String numberOfCuts = "count";
        String totalDamage = "totalDamage";
        Pair<Map<String, Object>, Set<String>> p = null;
        try {
            p = this.getParseBattleStatisticsMap(cookie);
        }
        catch (Exception e) {
            return new MessageChainBuilder().append((CharSequence)("\u829c\u6e56\uff0c\u53d1\u751f\u9519\u8bef\u4e86\uff0c\u9519\u8bef\u539f\u56e0 :" + e.getCause())).build();
        }
        Map<String, Object> memberData = p.getKey();
        Set<String> bossNames = p.getValue();
        if (!memberData.containsKey(username)) {
            return new MessageChainBuilder().append((CharSequence)("\u672a\u67e5\u8be2\u5230\u7528\u6237\u540d\u4e3a " + username + " \u7684\u7528\u6237\uff0c\u8bf7\u68c0\u67e5\u73a9\u5bb6\u540d\u662f\u5426\u6b63\u786e\uff0c\u6ce8\u610f\u73a9\u5bb6\u540d\u4e0d\u5f97\u5e26\u7a7a\u683c")).build();
        }
        Map map = (Map)memberData.get(username);
        Map<String, Long> bossTotDamage = this.getBossTotalDamage(memberData, bossNames);
        long t = bossTotDamage.getOrDefault(totalDamage, 0L);
        StringBuilder sb = new StringBuilder();
        sb.append("\u7528\u6237\u540d\uff1a" + username + "\n");
        sb.append("  \u603b\u4f24\u5bb3\uff1a" + map.getOrDefault(totalDamage, 0) + "\n");
        sb.append("  \u603b\u51fa\u5200\uff1a" + map.getOrDefault(numberOfCuts, 0) + "\n");
        sb.append("  \u603b\u4f24\u5bb3\u5360\u6bd4\uff1a" + NumUtil.getPercentage((Long)((Object)map.getOrDefault(totalDamage, 0)), t) + "\n\n");
        HashMap<String, Long> dataset1 = new HashMap<String, Long>();
        HashMap<String, Long> dataset2 = new HashMap<String, Long>();
        for (String bossName : bossNames) {
            Map bossMap = map.getOrDefault(bossName, new HashMap());
            sb.append("  " + bossName + "\uff1a\n");
            sb.append("    \u5bf9\u602a\u7269\u603b\u4f24\u5bb3\uff1a" + bossMap.getOrDefault(totalDamage, 0) + "\n");
            sb.append("    \u5bf9\u602a\u7269\u603b\u51fa\u5200\uff1a" + bossMap.getOrDefault(numberOfCuts, 0) + "\n");
            sb.append("    \u5bf9\u602a\u7269\u4f24\u5bb3\u5360\u6bd4\uff1a" + NumUtil.getPercentage(bossMap.getOrDefault(totalDamage, 0L), bossTotDamage.getOrDefault(bossName, 0L)) + "\n");
            dataset1.put(bossName, NumUtil.objectToLong(bossMap.getOrDefault(numberOfCuts, 0L)));
            dataset2.put(bossName, NumUtil.objectToLong(bossMap.getOrDefault(totalDamage, 0L)));
        }
        sb.append("\n");
        String s1 = ChartUtil.generateAPieChart(dataset1, username + " \u7684\u51fa\u5200\u60c5\u51b5");
        String s2 = ChartUtil.generateAPieChart(dataset2, username + " \u7684\u8f93\u51fa\u60c5\u51b5");
        return new MessageChainBuilder().append((CharSequence)sb.toString()).append((SingleMessage)GtReportMessageEventHandler.uploadImage(event, s1)).append((SingleMessage)GtReportMessageEventHandler.uploadImage(event, s2)).build();
    }

    public MessageChain doParseBattleStatistics(String cookie) {
        String numberOfCuts = "count";
        String totalDamage = "totalDamage";
        Pair<Map<String, Object>, Set<String>> p = null;
        try {
            p = this.getParseBattleStatisticsMap(cookie);
        }
        catch (Exception e) {
            return new MessageChainBuilder().append((CharSequence)("\u829c\u6e56\uff0c\u53d1\u751f\u9519\u8bef\u4e86\uff0c\u9519\u8bef\u539f\u56e0 :" + e.getCause())).build();
        }
        Map<String, Object> memberData = p.getKey();
        Set<String> bossNames = p.getValue();
        StringBuffer sb = new StringBuffer();
        TreeMap<Long, Map> sortMap = new TreeMap<Long, Map>((a, b) -> (int)(b - a));
        for (Map.Entry<String, Object> it : memberData.entrySet()) {
            Map map = (Map)it.getValue();
            map.put(USER_NAME, it.getKey());
            sortMap.put((Long)map.get(totalDamage), map);
        }
        sortMap.forEach((k, v) -> {
            Map map = v;
            sb.append("\u7528\u6237\u540d\uff1a" + map.get(USER_NAME) + "\n");
            sb.append("  \u603b\u4f24\u5bb3\uff1a" + map.getOrDefault(totalDamage, 0) + "\n");
            sb.append("  \u603b\u51fa\u5200\uff1a" + map.getOrDefault(numberOfCuts, 0) + "\n");
            for (String bossName : bossNames) {
                Map bossMap = map.getOrDefault(bossName, new HashMap());
                sb.append("  " + bossName + "\uff1a\n");
                sb.append("    \u5bf9\u602a\u7269\u603b\u4f24\u5bb3\uff1a" + bossMap.getOrDefault(totalDamage, 0) + "\n");
                sb.append("    \u5bf9\u602a\u7269\u603b\u51fa\u5200\uff1a" + bossMap.getOrDefault(numberOfCuts, 0) + "\n");
            }
            sb.append("\n");
        });
        sb.append("\u53c2\u4e0e\u4f1a\u6218\u4eba\u6570\uff1a" + sortMap.size() + "\n\n");
        for (String bossName : bossNames) {
            sb.append("\u5bf9" + bossName + "\u9020\u6210\u4f24\u5bb3\u6700\u9ad8\u7684\u662f\uff1a" + this.getMostDamageUser(memberData, bossName) + "\n\n");
        }
        sb.append("\u603b\u4f24\u5bb3\u6700\u9ad8\u7684\u662f\uff1a" + ((Map)sortMap.get(sortMap.firstKey())).get(USER_NAME));
        return new MessageChainBuilder().append((CharSequence)sb.toString()).build();
    }

    public MessageChain doParseFrontlineReporting(String cookie) {
        Map<String, Object> msg = null;
        try {
            System.out.println("cookie = " + cookie);
            msg = IOUtil.sendAndGetResponseMap(new URL(FRONTLINE_REPORTING_URL), "GET", this.getHeaders(cookie), null);
            System.out.println("msg = " + msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("******\u524d\u7ebf\u62a5\u9053******\n");
        Map data = msg.getOrDefault(DATA, new HashMap());
        List bossList = (List)data.get(BOSS);
        for (Map boss : bossList) {
            sb.append(boss.get(NAME) + "\uff1a\n");
            sb.append("  \u7b49\u7ea7\uff1a" + boss.get(LEVEL) + "\n");
            sb.append("  \u5c5e\u6027\uff1a" + boss.get(TYPE) + "\n");
            sb.append("  \u603b\u8840\u91cf\uff1a" + boss.get(TOTAL_HP) + "\n");
            sb.append("  \u5269\u4f59\u8840\u91cf\uff1a" + boss.get(REMAIN_HP) + "\n");
            double percentage = NumUtil.objectToDouble(boss.get(REMAIN_HP)) / NumUtil.objectToDouble(boss.get(TOTAL_HP));
            String str = String.valueOf(percentage * 100.0);
            if (str.length() > 5) {
                str = str.substring(0, 5);
            }
            sb.append("  \u5269\u4f59\u8840\u91cf\u5360\u6bd4\uff1a" + str + "%\n\n");
        }
        return new MessageChainBuilder().append((CharSequence)sb.toString()).build();
    }

    public MessageChain doParseBattleReport(String cookie) {
        Map<String, Object> msg = null;
        try {
            msg = IOUtil.sendAndGetResponseMap(new URL(BATTLE_REPORT_URL), "GET", this.getHeaders(cookie), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int c = 0;
        int maxDamage = 0;
        String maxDamageUser = "\u65e0";
        StringBuffer sb = new StringBuffer();
        sb.append("******\u4eca\u65e5\u4f1a\u6218\u62a5\u8868******\n");
        List data = msg.getOrDefault(DATA, new ArrayList());
        for (Map datum : data) {
            sb.append("\u7528\u6237\u540d\uff1a" + datum.get(USER_NAME) + "\n");
            sb.append("\u603b\u4f24\u5bb3\uff1a" + datum.get(DAMAGE_TOTAL) + "\n");
            List damageList = (List)datum.get(DAMAGE_LIST);
            int sum = 0;
            for (int i = 1; i <= 3; ++i) {
                sb.append("  \u7b2c" + i + "\u5200\uff1a");
                if (damageList == null || damageList.size() < i) {
                    sb.append("\u6682\u672a\u51fa\u5200\n");
                    continue;
                }
                sb.append("\n");
                Map damage = (Map)damageList.get(i - 1);
                String isKill = (Integer)damage.get(IS_KILL) == 1 ? "\u662f" : "\u5426";
                sb.append("    boss\uff1a" + damage.get(BOSS_NAME) + "\n");
                sb.append("    \u4f24\u5bb3\uff1a" + damage.get(DAMAGE) + "\n");
                sb.append("    \u662f\u5426\u5c3e\u5200\uff1a" + isKill + "\n");
                sum += ((Integer)damage.get(DAMAGE)).intValue();
                ++c;
            }
            if (sum > maxDamage) {
                maxDamage = sum;
                maxDamageUser = (String)datum.get(USER_NAME);
            }
            sb.append('\n');
        }
        sb.append("\u4eca\u65e5\u603b\u51fa\u5200\u4eba\u6570\uff1a" + data.size() + "\n");
        sb.append("\u4eca\u65e5\u51fa\u5200\u6570\uff1a" + c + "\n");
        sb.append("\u4eca\u65e5\u4f24\u5bb3\u6700\u9ad8\u73a9\u5bb6\uff1a" + maxDamageUser + "\n");
        sb.append("\u6700\u9ad8\u4f24\u5bb3\uff1a" + maxDamage);
        return new MessageChainBuilder().append((CharSequence)sb.toString()).build();
    }

    private Map<String, Long> getBossTotalDamage(Map<String, Object> memberData, Set<String> bossNames) {
        HashMap<String, Long> bossTotalDamage = new HashMap<String, Long>();
        long t = 0L;
        String totalDamage = "totalDamage";
        for (Map.Entry<String, Object> entry : memberData.entrySet()) {
            Map m = (Map)entry.getValue();
            t += ((Long)((Object)m.getOrDefault(totalDamage, 0))).longValue();
            for (String bossName : bossNames) {
                Map bossMap = m.getOrDefault(bossName, new HashMap());
                bossTotalDamage.put(bossName, bossTotalDamage.getOrDefault(bossName, 0L) + NumUtil.objectToLong(bossMap.getOrDefault(totalDamage, 0)));
            }
        }
        bossTotalDamage.put(totalDamage, t);
        return bossTotalDamage;
    }

    private Map<String, String> getHeaders(String cookie) {
        HashMap<String, String> heads = new HashMap<String, String>(10);
        heads.put("Cookie", cookie);
        return heads;
    }

    @Override
    public boolean shouldHandle(MessageEvent event, Context ctx) {
        return this.startWithKeywords(event, this.keywords);
    }
}

