/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.handler.impl;

import com.happysnaker.api.BingWallpaperAPI;
import com.happysnaker.api.PixivApi;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.exception.CanNotSendMessageException;
import com.happysnaker.exception.FileUploadException;
import com.happysnaker.handler.handler;
import com.happysnaker.handler.impl.GroupMessageEventHandler;
import com.happysnaker.proxy.Context;
import com.happysnaker.utils.IOUtil;
import com.happysnaker.utils.StringUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.SingleMessage;

@handler(priority=1)
public class ImageShareMessageEventHandler
extends GroupMessageEventHandler {
    public final String chickenSoup = "\u9e21\u6c64";
    public final String mysteriousImage = "\u795e\u79d8\u4ee3\u7801";
    public final String landscapeImage = "\u98ce\u666f\u56fe";
    public final String beautifulImage = "\u7f8e\u56fe";
    public final String seImage = "\u6da9\u56fe";
    public final String seImagePlus = "\u9ad8\u6e05\u6da9\u56fe";
    public final String beautifulImageUrl = "https://api.vvhan.com/api/acgimg";
    public final String chickenSoupUrl = "https://api.shadiao.pro/chp/";
    public final String duChickenSoupUrl = "https://api.shadiao.pro/du";
    private final Set<String> keywords = new HashSet<String>();

    public ImageShareMessageEventHandler() {
        this.keywords.add("\u9e21\u6c64");
        this.keywords.add("\u795e\u79d8\u4ee3\u7801");
        this.keywords.add("\u98ce\u666f\u56fe");
        this.keywords.add("\u7f8e\u56fe");
        this.keywords.add("\u6da9\u56fe");
        this.keywords.add("\u9ad8\u6e05\u6da9\u56fe");
    }

    @Override
    public List<MessageChain> handleMessageEvent(MessageEvent event, Context ctx) {
        String content = this.getPlantContent(event);
        ArrayList<MessageChain> ans = new ArrayList<MessageChain>();
        try {
            if (content.contains("\u9e21\u6c64")) {
                ans.add(this.doParseChickenSoup(event));
            }
            if (content.startsWith("\u795e\u79d8\u4ee3\u7801")) {
                List<String> tags = this.getTags(content, "\u795e\u79d8\u4ee3\u7801");
                ans.add(this.doParseMysteriousImage(event, tags));
            }
            if (content.startsWith("\u6da9\u56fe") || content.startsWith("\u9ad8\u6e05\u6da9\u56fe")) {
                String tem = content.startsWith("\u6da9\u56fe") ? "\u6da9\u56fe" : "\u9ad8\u6e05\u6da9\u56fe";
                this.doParseSeImageAndSend(event, this.getTags(content, tem), tem.equals("\u9ad8\u6e05\u6da9\u56fe"));
                return null;
            }
            if (content.contains("\u7f8e\u56fe")) {
                ans.add(this.doParseBeautifulImage(event));
            }
            if (content.contains("\u98ce\u666f\u56fe")) {
                ans.add(this.doParseLandscapeImage(event));
            }
        }
        catch (Exception e) {
            this.logError(event, e);
            ans.add(new MessageChainBuilder().append((CharSequence)"\u610f\u5916\u5730\u5931\u53bb\u4e86\u4e0e\u5730\u7403\u4e0a\u7684\u901a\u4fe1...\n\u9519\u8bef\u539f\u56e0\uff1a").append((CharSequence)(e.getMessage() == null ? e.getCause().toString() : e.getMessage())).build());
        }
        return ans;
    }

    private List<String> getTags(String content, String tem) {
        ArrayList<String> tags = new ArrayList<String>();
        List<String> strings = StringUtil.splitSpaces(content.replace(tem, ""));
        for (String s : strings) {
            if (s.isEmpty() || s.equals(tem)) continue;
            tags.add(s.trim());
        }
        return tags;
    }

    private MessageChain doParseLandscapeImage(MessageEvent event) throws MalformedURLException, FileUploadException {
        return new MessageChainBuilder().append((SingleMessage)ImageShareMessageEventHandler.uploadImage(event, new URL(BingWallpaperAPI.getRandomImageUrl()))).build();
    }

    private MessageChain doParseBeautifulImage(MessageEvent event) throws MalformedURLException, FileUploadException {
        return new MessageChainBuilder().append((SingleMessage)ImageShareMessageEventHandler.uploadImage(event, new URL("https://api.vvhan.com/api/acgimg"))).build();
    }

    private void doParseSeImageAndSend(MessageEvent event, List<String> tags, boolean isPlus) throws IOException, FileUploadException, CanNotSendMessageException {
        if (!RobotConfig.colorSwitch) {
            return;
        }
        String imgUrl = PixivApi.searchImage(tags, true, !isPlus);
        if (StringUtil.isNullOrEmpty(imgUrl)) {
            ImageShareMessageEventHandler.buildMessageChain("\u67e5\u65e0\u6b64\u56fe");
            return;
        }
        if (RobotConfig.colorStrategy == 4) {
            ImageShareMessageEventHandler.sendMsg(ImageShareMessageEventHandler.buildMessageChain(ImageShareMessageEventHandler.getQuoteReply(event), "\u989c\u8272\u56fe\u7247\u539f\u59cb\u94fe\u63a5\uff1a" + imgUrl), event);
            return;
        }
        Image image = ImageShareMessageEventHandler.uploadImage(event, new URL(imgUrl));
        String reachableImageUrl = Image.queryUrl((Image)image);
        if (StringUtil.isNullOrEmpty(reachableImageUrl)) {
            reachableImageUrl = imgUrl;
        }
        switch (RobotConfig.colorStrategy) {
            case 0: {
                return;
            }
            case 1: {
                ImageShareMessageEventHandler.sendMsg(ImageShareMessageEventHandler.buildMessageChain(ImageShareMessageEventHandler.getQuoteReply(event), "\u989c\u8272\u56fe\u7247\u94fe\u63a5\uff1a" + reachableImageUrl), event);
                break;
            }
            case 2: {
                ImageShareMessageEventHandler.sendMsg(ImageShareMessageEventHandler.buildMessageChain(image), event, (long)RobotConfig.pictureWithdrawalTime * 1000L);
                break;
            }
            case 3: {
                ImageShareMessageEventHandler.sendMsg(ImageShareMessageEventHandler.buildMessageChain(ImageShareMessageEventHandler.getQuoteReply(event), "\u989c\u8272\u56fe\u7247\u94fe\u63a5\uff1a" + reachableImageUrl), event);
                ImageShareMessageEventHandler.sendMsg(ImageShareMessageEventHandler.buildMessageChain(image), event, (long)RobotConfig.pictureWithdrawalTime * 1000L);
            }
        }
    }

    private MessageChain doParseMysteriousImage(MessageEvent event, List<String> tags) throws IOException, FileUploadException {
        String imgUrl = PixivApi.searchImage(tags, false, false);
        if (StringUtil.isNullOrEmpty(imgUrl)) {
            return ImageShareMessageEventHandler.buildMessageChain("\u67e5\u65e0\u6b64\u56fe");
        }
        this.info(String.format("Not r18 color image url: %s", imgUrl));
        return new MessageChainBuilder().append((SingleMessage)ImageShareMessageEventHandler.uploadImage(event, new URL(imgUrl))).build();
    }

    private MessageChain doParseChickenSoup(MessageEvent event) throws IOException, FileUploadException {
        String chickenSoupUrl = this.chickenSoupUrl;
        if (Math.random() < RobotConfig.duChickenSoupProbability) {
            chickenSoupUrl = this.duChickenSoupUrl;
        }
        Map<String, Object> map = IOUtil.sendAndGetResponseMap(new URL(chickenSoupUrl), "GET", null, null);
        String text = (String)((Map)map.get("data")).get("text");
        return new MessageChainBuilder().append((CharSequence)text).append((SingleMessage)ImageShareMessageEventHandler.uploadImage(event, new URL("https://api.vvhan.com/api/acgimg"))).build();
    }

    @Override
    public boolean shouldHandle(MessageEvent event, Context ctx) {
        return this.startWithKeywords(event, this.keywords);
    }
}

