/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.handler.impl;

import com.happysnaker.api.BaiKeApi;
import com.happysnaker.exception.CanNotSendMessageException;
import com.happysnaker.exception.FileUploadException;
import com.happysnaker.handler.handler;
import com.happysnaker.handler.impl.GroupMessageEventHandler;
import com.happysnaker.proxy.Context;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;

@handler
public class KnowledgeSearchMessageEventHandler
extends GroupMessageEventHandler {
    public static final String BAIDU_BAIKE = "\u767e\u5ea6\u767e\u79d1";
    private final HashSet<String> keywords = new HashSet();

    public KnowledgeSearchMessageEventHandler() {
        this.keywords.add(BAIDU_BAIKE);
    }

    @Override
    public List<MessageChain> handleMessageEvent(MessageEvent event, Context ctx) {
        try {
            return this.parseBaidu(event);
        }
        catch (Exception e) {
            this.logError(event, e);
            return KnowledgeSearchMessageEventHandler.buildMessageChainAsSingletonList("\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    protected List<MessageChain> parseBaidu(MessageEvent event) throws MalformedURLException, FileUploadException, CanNotSendMessageException {
        String content = this.getPlantContent(event).replace(BAIDU_BAIKE, "");
        Map<String, String> map = BaiKeApi.search(content);
        if (map == null) {
            return KnowledgeSearchMessageEventHandler.buildMessageChainAsSingletonList(KnowledgeSearchMessageEventHandler.getQuoteReply(event), "\u68c0\u7d22\u5931\u8d25\uff0c\u6362\u4e2a\u5173\u952e\u8bcd\u8bd5\u8bd5\u5427");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u6807\u9898\uff1a");
        sb.append(map.get("title")).append("\n");
        sb.append("\u63cf\u8ff0\uff1a");
        sb.append(map.get("desc")).append("\n");
        sb.append(map.get("content")).append("\n");
        if (map.get("image") != null) {
            return KnowledgeSearchMessageEventHandler.buildMessageChainAsSingletonList(sb.toString(), KnowledgeSearchMessageEventHandler.uploadImage(event, new URL(map.get("image"))));
        }
        return KnowledgeSearchMessageEventHandler.buildMessageChainAsSingletonList(sb.toString());
    }

    @Override
    public boolean shouldHandle(MessageEvent event, Context ctx) {
        return this.startWithKeywords(event, this.keywords);
    }
}

