/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.intercept.impl;

import com.happysnaker.config.RobotConfig;
import com.happysnaker.intercept.impl.AdaptInterceptor;
import com.happysnaker.intercept.intercept;
import com.happysnaker.utils.Trie;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageSource;

@intercept
public class SensitiveAfterWordInterceptor
extends AdaptInterceptor {
    private final Trie trie = new Trie();

    private boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public SensitiveAfterWordInterceptor() {
        for (String s : RobotConfig.sensitiveWord) {
            this.trie.insert(s);
        }
    }

    public boolean containsSensitiveWord(char[] text, int from) {
        int n = text.length;
        boolean skip = RobotConfig.skipIsMeaninglessWord;
        int skipStep = RobotConfig.skipStep;
        Trie node = this.trie;
        for (int i = from; i < n; ++i) {
            char ch = text[i];
            if (node.nextNode(ch) == null) {
                if (skip && !this.isChinese(ch) && !Character.isLetterOrDigit(ch) || skipStep-- > 0) continue;
                return false;
            }
            if (!(node = node.nextNode(ch)).isStringEnd()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean interceptBefore(MessageEvent event) {
        if (!(event instanceof GroupMessageEvent)) {
            return false;
        }
        GroupMessageEvent groupEvent = (GroupMessageEvent)event;
        String gid = String.valueOf(groupEvent.getGroup().getId());
        if (!RobotConfig.enableSensitiveWordDetection.contains(gid)) {
            return false;
        }
        char[] str = SensitiveAfterWordInterceptor.getOnlyPlainContent(event).trim().toCharArray();
        int n = str.length;
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.containsSensitiveWord(str, i) || ++count < RobotConfig.withdrawalThreshold) continue;
            MessageChain chain = SensitiveAfterWordInterceptor.buildMessageChain(new At(event.getSender().getId()), "\n", "\u8b66\u544a\uff0c\u4f60\u7684\u53d1\u8a00\u8fdd\u53cd\u4e86\u7fa4\u5185\u76f8\u5173\u89c4\u5b9a\uff0c\u8bf7\u4e0d\u8981\u53d1\u5e03\u8272\u60c5\u53ca\u653f\u6cbb\u76f8\u5173\u8a00\u8bba");
            event.getSubject().sendMessage((Message)chain);
            MessageSource.recall((MessageSource)event.getSource());
            return true;
        }
        return false;
    }
}

