/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.permission;

import com.happysnaker.config.RobotConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Permission {
    public static final int NONE = -1;
    public static final int SUPER_ADMINISTRATOR = 0;
    public static final int ADMINISTRATOR = 1;
    public static final int GROUP_ADMINISTRATOR = 2;
    public static final int GT_ADMINISTRATOR = 101;

    public static List<String> getGtAdminList() {
        return RobotConfig.gtAdministrator;
    }

    public static List<String> getGroupAdminList() {
        return RobotConfig.groupAdministrator;
    }

    public static List<String> getBotAdminList() {
        return RobotConfig.administrator;
    }

    public static boolean hasSuperAdmin(String qq) {
        return Permission.getPermissionSet(qq).contains(0);
    }

    public static boolean hasAdmin(String qq) {
        return Permission.getPermissionSet(qq).contains(1) || Permission.hasSuperAdmin(qq);
    }

    public static boolean hasGroupAdmin(String qq) {
        return Permission.getPermissionSet(qq).contains(2) || Permission.hasAdmin(qq);
    }

    public static boolean hasGtAdmin(String qq) {
        return Permission.getPermissionSet(qq).contains(101) || Permission.hasGroupAdmin(qq);
    }

    public static Set<Integer> getPermissionSet(String qq) {
        List<String> gtAdminList;
        HashSet<Integer> permissionList = new HashSet<Integer>();
        List<String> botAdminList = Permission.getBotAdminList();
        for (int i = 0; i < botAdminList.size(); ++i) {
            if (!botAdminList.get(i).equals(qq)) continue;
            permissionList.add(i == 0 ? 0 : 1);
        }
        if (Permission.getGroupAdminList().contains(qq)) {
            permissionList.add(2);
        }
        if ((gtAdminList = Permission.getGtAdminList()).contains(qq)) {
            permissionList.add(101);
        }
        return permissionList;
    }

    public static int compare(String qq1, String qq2) {
        Set<Integer> set1 = Permission.getPermissionSet(qq1);
        Set<Integer> set2 = Permission.getPermissionSet(qq2);
        int p1 = -1;
        int p2 = -1;
        for (Integer p : set1) {
            if (p1 != -1 && p >= p1) continue;
            p1 = p;
        }
        for (Integer p : set2) {
            if (p2 != -1 && p >= p2) continue;
            p2 = p;
        }
        p1 = p1 == -1 ? Integer.MAX_VALUE : p1;
        p2 = p2 == -1 ? Integer.MAX_VALUE : p2;
        return p2 - p1;
    }
}

