/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.proxy;

import com.happysnaker.config.ConfigManager;
import com.happysnaker.exception.CanNotSendMessageException;
import com.happysnaker.handler.MessageEventHandler;
import com.happysnaker.intercept.Interceptor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;

public class Context {
    private Map<String, Object> params;
    private final List<MessageEventHandler> handlerList;
    private final List<Interceptor> interceptorList;
    private String message;
    private int index;
    private boolean execute;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Context(List<MessageEventHandler> handlerList, List<Interceptor> interceptorList) {
        this.handlerList = handlerList;
        this.interceptorList = interceptorList;
    }

    public Context set(String key, Object val) {
        this.params.put(key, val);
        return this;
    }

    public Object get(String key) {
        return this.params.get(key);
    }

    public Context addHandler(MessageEventHandler handler2) {
        this.handlerList.add(handler2);
        return this;
    }

    public Context addHandlerToNext(MessageEventHandler handler2) {
        this.handlerList.add(this.index + 1, handler2);
        return this;
    }

    public void continueExecute() {
        this.execute = true;
    }

    public void execute(MessageEvent event) {
        this.execute = true;
        while (this.index < this.handlerList.size() && this.execute) {
            MessageEventHandler handler2 = this.handlerList.get(this.index);
            if (handler2.shouldHandle(event, this)) {
                this.execute = false;
                try {
                    Interceptor interceptor;
                    List<MessageChain> res = handler2.handleMessageEvent(event, this);
                    Iterator<Interceptor> iterator = this.interceptorList.iterator();
                    while (iterator.hasNext() && (res = (interceptor = iterator.next()).interceptAfter(event, res)) != null) {
                    }
                    this.reply(res, event);
                }
                catch (CanNotSendMessageException e) {
                    e.printStackTrace();
                    ConfigManager.recordFailLog(event, e.getMessage());
                }
            }
            ++this.index;
        }
    }

    private void reply(List<MessageChain> replyMessages, MessageEvent event) throws CanNotSendMessageException {
        Contact contact = event.getSubject();
        if (replyMessages == null) {
            return;
        }
        try {
            for (MessageChain replyMessage : replyMessages) {
                if (replyMessage == null || replyMessage.isEmpty()) continue;
                contact.sendMessage((Message)replyMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CanNotSendMessageException("Can not send message: \"" + replyMessages + "\", the contact is: " + contact + "\nCause by " + e.getCause().toString());
        }
    }
}

