/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.proxy;

import com.happysnaker.config.RobotConfig;
import com.happysnaker.handler.MessageEventHandler;
import com.happysnaker.handler.handler;
import com.happysnaker.intercept.Interceptor;
import com.happysnaker.intercept.intercept;
import com.happysnaker.proxy.Context;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.data.MessageChain;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class MessageHandlerProxy
implements MessageEventHandler {
    public final String packageName = "com.happysnaker";
    private final List<MessageEventHandler> handlers = new ArrayList<MessageEventHandler>();
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();

    public MessageHandlerProxy() throws Exception {
        Reflections reflections = new Reflections("com.happysnaker", new Scanner[0]);
        Set<Class<?>> handlerCs = reflections.getTypesAnnotatedWith(handler.class);
        Set<Class<?>> inspectCs = reflections.getTypesAnnotatedWith(intercept.class);
        for (Class<?> c : handlerCs) {
            if (Modifier.isAbstract(c.getModifiers())) continue;
            try {
                this.handlers.add((MessageEventHandler)c.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Class<?> c : inspectCs) {
            try {
                this.interceptors.add((Interceptor)c.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        this.handlers.sort((h1, h2) -> {
            handler a1 = h1.getClass().getAnnotation(handler.class);
            handler a2 = h2.getClass().getAnnotation(handler.class);
            return a2.priority() - a1.priority();
        });
        this.interceptors.sort((i1, i2) -> {
            intercept a1 = i1.getClass().getAnnotation(intercept.class);
            intercept a2 = i2.getClass().getAnnotation(intercept.class);
            return a2.order() - a1.order();
        });
        RobotConfig.logger.info("HRobot handlers and filters loading finished, total " + this.handlers.size() + " handlers, " + this.interceptors.size() + " inspectors.");
    }

    @Override
    public List<MessageChain> handleMessageEvent(MessageEvent event, Context ctx) {
        if (ctx == null) {
            ctx = new Context(this.handlers, this.interceptors);
        }
        ctx.execute(event);
        return null;
    }

    @Override
    public boolean shouldHandle(MessageEvent event, Context ctx) {
        for (Interceptor filter : this.interceptors) {
            if (!filter.interceptBefore(event)) continue;
            return false;
        }
        return true;
    }
}

