/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.starter;

import com.happysnaker.CustomRegistry;
import com.happysnaker.Main;
import com.happysnaker.Test;
import com.happysnaker.config.ConfigManager;
import com.happysnaker.config.Logger;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.cron.RobotCronJob;
import com.happysnaker.proxy.MessageHandlerProxy;
import com.happysnaker.starter.HRobotStartPrinter;
import com.happysnaker.starter.HRobotVersionChecker;
import com.happysnaker.starter.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import kotlinx.coroutines.CoroutineScope;
import net.mamoe.mirai.console.plugin.jvm.JavaPlugin;
import net.mamoe.mirai.event.Event;
import net.mamoe.mirai.event.EventChannel;
import net.mamoe.mirai.event.GlobalEventChannel;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MessageEvent;
import org.yaml.snakeyaml.Yaml;

public class HRobotStarter {
    private static MessageHandlerProxy messageHandler;

    public static void Start(JavaPlugin plugin) throws Exception {
        HRobotStartPrinter.printBanner();
        Patch.patch();
        try {
            HRobotStarter.initRobotConfig(plugin);
        }
        catch (IOException | IllegalAccessException e) {
            e.printStackTrace();
        }
        HRobotStarter.loadSensitiveWord();
        messageHandler = new MessageHandlerProxy();
        EventChannel instance = GlobalEventChannel.INSTANCE.parentScope((CoroutineScope)Main.INSTANCE);
        instance.subscribeAlways(GroupMessageEvent.class, event -> {
            if (messageHandler.shouldHandle((MessageEvent)event, null)) {
                messageHandler.handleMessageEvent((MessageEvent)event, null);
            }
        });
        CustomRegistry.registry((EventChannel<Event>)instance);
        RobotCronJob.cron();
        Test.test(new Object[0]);
        HRobotVersionChecker.checkVersion();
    }

    public static synchronized void initRobotConfig(JavaPlugin plugin) throws IllegalAccessException, IOException {
        Yaml yaml = new Yaml();
        if (plugin != null) {
            RobotConfig.logger = plugin.getLogger();
            RobotConfig.configFolder = plugin.getConfigFolder();
            RobotConfig.dataFolder = plugin.getDataFolder();
        }
        File file = new File(RobotConfig.configFolder + "/" + RobotConfig.mainConfigPathName);
        Class<RobotConfig> c = RobotConfig.class;
        Field[] fields = c.getDeclaredFields();
        if (file.exists()) {
            Logger.info("\u6b63\u5728\u8bfb\u53d6\u5316\u673a\u5668\u4eba\u914d\u7f6e\u6587\u4ef6...");
            Map map = null;
            try (Field[] in = new FileInputStream(file);){
                map = yaml.loadAs((InputStream)in, Map.class);
            }
            if (map != null) {
                for (Field field : fields) {
                    if (!map.containsKey(field.getName())) continue;
                    try {
                        if (map.get(field.getName()) == null) continue;
                        field.set(null, map.get(field.getName()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Logger.info("\u673a\u5668\u4eba\u914d\u7f6e\u914d\u7f6e\u521d\u59cb\u5316\u5b8c\u6210");
        } else {
            Logger.info("\u672a\u68c0\u6d4b\u5230\u914d\u7f6e\u6587\u4ef6\uff0c\u6b63\u5728\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u6a21\u677f");
            boolean newFile = file.createNewFile();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file, false);){
                String template = ConfigManager.TEMPLATE;
                fileOutputStream.write(template.getBytes(StandardCharsets.UTF_8));
                Logger.info("\u6210\u529f\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u521d\u59cb\u6a21\u677f\uff0c\u8bf7\u4f60\u586b\u5199\u914d\u7f6e\u6587\u4ef6\uff0c\u91cd\u542f\u673a\u5668\u4eba\u751f\u6548");
                Thread.sleep(1500L);
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.error("\u914d\u7f6e\u6587\u4ef6\u6a21\u677f\u586b\u5145\u9519\u8bef\uff0c\u8bf7\u624b\u52a8\u914d\u7f6e\uff0c\u53ef\u524d\u5f80 Github \u5b98\u7f51\u67e5\u8be2");
            }
        }
    }

    public static void loadSensitiveWord() throws IOException, InterruptedException {
        File file = new File(ConfigManager.getConfigFilePath(RobotConfig.sensitiveWordPathName));
        RobotConfig.sensitiveWord = new HashSet<String>();
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String word = null;
                while ((word = reader.readLine()) != null) {
                    RobotConfig.sensitiveWord.add(word);
                }
            }
        } else {
            byte b;
            boolean newFile = file.createNewFile();
            Logger.info("\u654f\u611f\u8bcd\u5e93\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6b63\u5728\u521b\u5efa\u654f\u611f\u8bcd\u5e93\u6587\u4ef6\uff0c\u4f60\u53ef\u6dfb\u52a0\u654f\u611f\u8bcd\u5230\u6b64\u6587\u4ef6\u4e2d\uff0c\u8def\u5f84\uff1aconfig/sensitiveWord.txt");
            InputStream inputStream = ConfigManager.class.getClassLoader().getResourceAsStream("config/sensitiveWord.txt");
            assert (inputStream != null);
            FileOutputStream outputStream = new FileOutputStream(file);
            while ((b = (byte)inputStream.read()) != -1) {
                outputStream.write(b);
            }
            inputStream.close();
            outputStream.close();
            Logger.info("\u6210\u529f\u751f\u6210\u9ed8\u8ba4\u654f\u611f\u8bcd\u5e93\uff0c\u91cd\u542f\u673a\u5668\u4eba\u751f\u6548");
            Thread.sleep(1500L);
        }
    }
}

