/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.utils;

import com.happysnaker.config.ConfigManager;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.cron.RobotCronJob;
import com.happysnaker.utils.Pair;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

@Deprecated
public class ChartUtil {
    public static final String directionPath;

    public static String generateAPieChart(Map<String, Long> dataset, String title) throws IOException {
        try {
            Font font = new Font("\u5b8b\u4f53", 1, 15);
            DefaultPieDataset pds = new DefaultPieDataset();
            for (Map.Entry<String, Long> it : dataset.entrySet()) {
                pds.setValue((Comparable)((Object)it.getKey()), it.getValue());
            }
            JFreeChart chart = ChartFactory.createPieChart(title, (PieDataset)pds, true, false, true);
            chart.getTitle().setFont(font);
            PiePlot plot = (PiePlot)chart.getPlot();
            plot.setLabelFont(font);
            chart.getLegend().setItemFont(font);
            plot.setStartAngle(1.57f);
            plot.setForegroundAlpha(0.7f);
            plot.setBackgroundAlpha(0.0f);
            plot.setLabelGenerator(new StandardPieSectionLabelGenerator("{0}({1})/{2}"));
            String path = directionPath + UUID.randomUUID() + ".jpg";
            ChartUtilities.saveChartAsJPEG(new File(path), chart, 800, 400);
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String generateALineChart(List<Pair<String, List<Pair<String, Double>>>> datasets, String title, String rowTitle, String colTitle) throws IOException {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (Pair<String, List<Pair<String, Double>>> dataset : datasets) {
            for (Pair<String, Double> it : dataset.getValue()) {
                ds.setValue(it.getValue(), (Comparable)((Object)dataset.getKey()), (Comparable)((Object)it.getKey()));
            }
        }
        Font font = new Font("\u5b8b\u4f53", 1, 20);
        JFreeChart chart = ChartFactory.createLineChart3D(title, rowTitle, colTitle, ds, PlotOrientation.VERTICAL, true, true, true);
        chart.getTitle().setFont(font);
        font = new Font("\u5b8b\u4f53", 1, 15);
        chart.getLegend().setItemFont(font);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.getDomainAxis().setLabelFont(font);
        plot.getDomainAxis().setTickLabelFont(font);
        plot.getRangeAxis().setLabelFont(font);
        try {
            chart.setBackgroundImage(ImageIO.read(new URL("https://img.ixintu.com/download/jpg/201911/d57bee34508e4424145f0a376445edf0.jpg?x-oss-process=image/crop,x_0,y_0,w_960,h_1025")));
            plot.setBackgroundImage(ImageIO.read(new URL("https://tse1-mm.cn.bing.net/th/id/R-C.055d9409e760c9b7d312035935ec9dd3?rik=oKLKEIOJLEjiaw&riu=http%3a%2f%2fpic31.photophoto.cn%2f20140613%2f0008020944439977_b.jpg&ehk=3JoY27qXd1Os6r9qPinZtuhBDtGL%2bCK9ZKVfG9tRbkU%3d&risl=&pid=ImgRaw&r=0")));
        }
        catch (Exception it) {
            // empty catch block
        }
        plot.setForegroundAlpha(1.0f);
        String path = directionPath + UUID.randomUUID() + ".jpg";
        ChartUtilities.saveChartAsJPEG(new File(path), chart, 800, 400);
        return path;
    }

    public static String generateHistogram(List<Pair<String, List<Pair<String, Double>>>> datasets, String title, String rowTitle, String colTitle) throws IOException {
        DefaultCategoryDataset ds = new DefaultCategoryDataset();
        for (Pair<String, List<Pair<String, Double>>> dataset : datasets) {
            for (Pair<String, Double> it : dataset.getValue()) {
                ds.setValue(it.getValue(), (Comparable)((Object)dataset.getKey()), (Comparable)((Object)it.getKey()));
            }
        }
        Font font = new Font("\u5b8b\u4f53", 1, 20);
        JFreeChart chart = ChartFactory.createBarChart(title, rowTitle, colTitle, ds, PlotOrientation.VERTICAL, true, true, true);
        chart.getTitle().setFont(font);
        font = new Font("\u5b8b\u4f53", 1, 15);
        chart.getLegend().setItemFont(font);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.getDomainAxis().setLabelFont(font);
        plot.getDomainAxis().setTickLabelFont(font);
        plot.getRangeAxis().setLabelFont(font);
        plot.setForegroundAlpha(1.0f);
        String path = directionPath + UUID.randomUUID() + ".jpg";
        ChartUtilities.saveChartAsJPEG(new File(path), chart, 800, 500);
        return path;
    }

    static {
        RobotConfig.logger.info("\u6ce8\u518c\u540e\u53f0\u6e05\u7406\u4efb\u52a1...");
        RobotCronJob.addCronTask(() -> {
            File file = new File(ConfigManager.getDataFilePath("img"));
            if (!file.exists() || !file.isDirectory()) {
                file.mkdir();
            } else {
                for (File listFile : file.listFiles()) {
                    if (!listFile.isFile()) continue;
                    listFile.delete();
                }
                RobotConfig.logger.info("\u5df2\u6e05\u7406\u4e0d\u8981\u7684\u56fe\u7247");
            }
        });
        directionPath = ConfigManager.getDataFilePath("img/");
    }
}

