/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.utils;

import com.alibaba.fastjson.JSONObject;
import com.happysnaker.config.Logger;
import com.happysnaker.config.RobotConfig;
import com.happysnaker.utils.MapGetter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;

public class IOUtil {
    private static HttpURLConnection getUrlConnection(URL obj, String method, Map<String, String> heads, String postParam, long timeout) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setRequestMethod(method.toUpperCase(Locale.ROOT));
        conn.setRequestProperty("Connection", "keep-Alive");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "Happysnaker-HPRobot-v1.002");
        if (heads != null) {
            for (Map.Entry<String, String> it : heads.entrySet()) {
                conn.setRequestProperty(it.getKey(), it.getValue());
            }
        }
        conn.setInstanceFollowRedirects(true);
        if (timeout > 0L) {
            conn.setConnectTimeout((int)timeout);
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.connect();
        if (postParam != null) {
            OutputStream out = conn.getOutputStream();
            out.write(postParam.getBytes());
            out.flush();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> sendAndGetResponseMap(URL obj, String method, Map<String, String> heads, String postParam, long timeout) throws IOException {
        HttpURLConnection conn = IOUtil.getUrlConnection(obj, method, heads, postParam, timeout);
        int code = conn.getResponseCode();
        StringBuilder msg = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                msg.append(line).append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            conn.disconnect();
        }
        Map map = JSONObject.parseObject(msg.toString(), Map.class);
        map.put("code", code);
        return map;
    }

    public static Map<String, Object> sendAndGetResponseMap(URL obj, String method, Map<String, String> heads, String postParam) throws IOException {
        return IOUtil.sendAndGetResponseMap(obj, method, heads, postParam, RobotConfig.timeout);
    }

    public static MapGetter sendAndGetResponseMapGetter(URL obj, String method, Map<String, String> heads, String postParam) throws IOException {
        return new MapGetter(IOUtil.sendAndGetResponseMap(obj, method, heads, postParam, RobotConfig.timeout));
    }

    public static InputStream sendAndGetResponseStream(URL obj, String method, Map<String, String> heads, String postParam, long timeout) throws IOException {
        HttpURLConnection conn = IOUtil.getUrlConnection(obj, method, heads, postParam, timeout);
        return conn.getInputStream();
    }

    public static InputStream sendAndGetResponseStream(URL obj, String method, Map<String, String> heads, String postParam) throws IOException {
        return IOUtil.sendAndGetResponseStream(obj, method, heads, postParam, RobotConfig.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendAndGetResponseString(URL obj, String method, Map<String, String> heads, String postParam, long timeout) throws IOException {
        HttpURLConnection conn = IOUtil.getUrlConnection(obj, method, heads, postParam, timeout);
        StringBuilder msg = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                msg.append(line).append("\n");
            }
        }
        finally {
            conn.disconnect();
        }
        Logger.debug("Send request to " + obj + " and get response " + msg);
        return msg.toString();
    }

    public static String sendAndGetResponseString(URL obj, String method, Map<String, String> heads, String postParam) throws IOException {
        return IOUtil.sendAndGetResponseString(obj, method, heads, postParam, RobotConfig.timeout);
    }

    public static synchronized void writeToFile(File file, String message) throws FileNotFoundException {
        IOUtil.writeToFile(file, message, true);
    }

    public static synchronized void writeToFile(File file, String message, boolean append) throws FileNotFoundException {
        try (FileOutputStream out = new FileOutputStream(file, append);){
            out.write(message.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized void writeToFile(File file, InputStream in) throws FileNotFoundException {
        try (FileOutputStream out = new FileOutputStream(file, true);){
            int b;
            while ((b = in.read()) != -1) {
                out.write(b);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static synchronized String readFromFile(File file) {
        String string;
        FileInputStream in = new FileInputStream(file);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder msg = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                msg.append(line).append("\n");
            }
            string = msg.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        in.close();
        return string;
    }

    public static synchronized void replaceFile(File file, String seq, String target) throws FileNotFoundException {
        String content = IOUtil.readFromFile(file);
        assert (content != null);
        IOUtil.writeToFile(file, content.replaceAll(seq, target), false);
    }
}

