/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.utils;

import com.happysnaker.cron.PeriodCronJob;
import com.happysnaker.cron.RobotCronJob;
import com.happysnaker.exception.CanNotSendMessageException;
import com.happysnaker.exception.FileUploadException;
import com.happysnaker.utils.IOUtil;
import com.happysnaker.utils.OfUtil;
import com.happysnaker.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.CannotProceedException;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.message.code.MiraiCode;
import net.mamoe.mirai.message.data.At;
import net.mamoe.mirai.message.data.AtAll;
import net.mamoe.mirai.message.data.Face;
import net.mamoe.mirai.message.data.Image;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.MessageChain;
import net.mamoe.mirai.message.data.MessageChainBuilder;
import net.mamoe.mirai.message.data.MessageKey;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.message.data.QuoteReply;
import net.mamoe.mirai.message.data.SingleMessage;
import net.mamoe.mirai.utils.ExternalResource;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;

public class RobotUtil {
    public static final String TAG_PATTERN = "(\\[hrobot::\\$.*?])(\\((.*?)\\))";

    public static Set<String> getBotsAllGroupId() {
        List bots = Bot.getInstances();
        HashSet<String> ans = new HashSet<String>();
        for (Bot bot : bots) {
            for (Group group : bot.getGroups()) {
                ans.add(String.valueOf(group.getId()));
            }
        }
        return ans;
    }

    public static MessageChain replaceFaceFromContent(String text) {
        String regex = "\\{face:\\d+\\}";
        MessageChainBuilder messageChainBuilder = new MessageChainBuilder();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        boolean findFace = false;
        int start = 0;
        int end = 0;
        while (matcher.find()) {
            String[] split;
            findFace = true;
            end = matcher.start();
            if (start != end) {
                messageChainBuilder.append((SingleMessage)new PlainText(text.substring(start, end)));
            }
            for (String s1 : split = matcher.group().split("\\D+")) {
                if (s1.isEmpty()) continue;
                try {
                    int face = Integer.parseInt(s1);
                    messageChainBuilder.append((SingleMessage)new Face(face));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            start = matcher.end();
        }
        return findFace ? messageChainBuilder.build() : messageChainBuilder.append((CharSequence)text).build();
    }

    public static String getContent(MessageEvent event) {
        if (event == null) {
            return null;
        }
        return RobotUtil.getContent(event.getMessage());
    }

    public static String getContent(MessageChain chain) {
        if (chain == null) {
            return null;
        }
        return chain.serializeToMiraiCode();
    }

    public static Contact getAdaptContact() {
        Iterator iterator = Bot.getInstances().iterator();
        if (iterator.hasNext()) {
            Bot bot = (Bot)iterator.next();
            return bot.getFriend(bot.getId());
        }
        return null;
    }

    private static Pair<String, String> findValidTagAndVal(Matcher matcher) {
        String tag = matcher.group(1);
        String val = matcher.group(2);
        tag = tag.substring(10, tag.length() - 1);
        val = val.substring(1, val.length() - 1);
        if (tag.isEmpty()) {
            return null;
        }
        return Pair.of(tag, val);
    }

    public static MessageChain parseMiraiCode(String content, MessageEvent event) throws CannotProceedException {
        Pattern pattern = Pattern.compile(TAG_PATTERN);
        Matcher matcher = pattern.matcher(content);
        int fromIndex = 0;
        MessageChainBuilder builder = new MessageChainBuilder();
        while (matcher.find()) {
            Pair<String, String> pair = RobotUtil.findValidTagAndVal(matcher);
            if (pair == null) continue;
            String tag = pair.getKey();
            String val = pair.getValue();
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)content.substring(fromIndex, matcher.start())));
            fromIndex = matcher.end();
            try {
                switch (tag.toLowerCase()) {
                    case "img": {
                        if (val.startsWith("http")) {
                            builder.append((SingleMessage)RobotUtil.uploadImage(event, new URL(val)));
                            break;
                        }
                        builder.append((SingleMessage)RobotUtil.uploadImage(event, val));
                        break;
                    }
                    case "quote": {
                        builder.append((SingleMessage)RobotUtil.getQuoteReply(event));
                        break;
                    }
                    case "at": {
                        if (val.equals("sender")) {
                            builder.append((SingleMessage)new At(RobotUtil.getSenderId2(event)));
                            break;
                        }
                        builder.append((SingleMessage)(Long.parseLong(val) == -1L ? AtAll.INSTANCE : new At(Long.parseLong(val))));
                        break;
                    }
                    default: {
                        builder.append((Message)MiraiCode.deserializeMiraiCode((String)content.substring(matcher.start(), matcher.end())));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CannotProceedException(String.format("\u89e3\u6790\u8bed\u4e49\u6807\u7b7e %s \u51fa\u9519\uff0c\u5f02\u5e38\u539f\u56e0 %s, \u53ef\u80fd\u662f\u7f51\u7edc\u8d85\u65f6\u6216\u8005\u503c\u7684\u683c\u5f0f\u4e0d\u6b63\u786e", matcher.group(0), e.getCause()));
            }
        }
        builder.append((Message)MiraiCode.deserializeMiraiCode((String)content.substring(fromIndex)));
        return builder.build();
    }

    public static MessageChain parseMiraiCode(String content, Contact contact) throws CannotProceedException {
        Pattern pattern = Pattern.compile(TAG_PATTERN);
        Matcher matcher = pattern.matcher(content);
        int fromIndex = 0;
        MessageChainBuilder builder = new MessageChainBuilder();
        while (matcher.find()) {
            Pair<String, String> pair = RobotUtil.findValidTagAndVal(matcher);
            if (pair == null) continue;
            String tag = pair.getKey();
            String val = pair.getValue();
            builder.append((Message)MiraiCode.deserializeMiraiCode((String)content.substring(fromIndex, matcher.start())));
            fromIndex = matcher.end();
            try {
                switch (tag) {
                    case "img": {
                        if (val.startsWith("http")) {
                            builder.append((SingleMessage)RobotUtil.uploadImage(contact, new URL(val)));
                            break;
                        }
                        builder.append((SingleMessage)RobotUtil.uploadImage(contact, val));
                        break;
                    }
                    case "at": {
                        if (val.equals("sender")) {
                            throw new CannotProceedException("\u6ca1\u6709\u6d88\u606f\u6e90\uff0c\u65e0\u6cd5\u5f15\u7528\u53d1\u9001\u4eba");
                        }
                        builder.append((SingleMessage)(Long.parseLong(val) == -1L ? AtAll.INSTANCE : new At(Long.parseLong(val))));
                        break;
                    }
                    case "quote": {
                        throw new CannotProceedException("\u6ca1\u6709\u6d88\u606f\u6e90\uff0c\u65e0\u6cd5\u5f15\u7528\u53d1\u9001\u4eba");
                    }
                    default: {
                        builder.append((Message)MiraiCode.deserializeMiraiCode((String)content.substring(matcher.start(), matcher.end())));
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CannotProceedException(String.format("\u89e3\u6790\u8bed\u4e49\u6807\u7b7e %s \u51fa\u9519\uff0c\u5f02\u5e38\u539f\u56e0 %s, \u53ef\u80fd\u662f\u7f51\u7edc\u8d85\u65f6\u6216\u8005\u503c\u7684\u683c\u5f0f\u4e0d\u6b63\u786e", matcher.group(0), e.getCause()));
            }
        }
        builder.append((Message)MiraiCode.deserializeMiraiCode((String)content.substring(fromIndex)));
        return builder.build();
    }

    public static String getOnlyPlainContent(MessageEvent event) {
        if (event == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (SingleMessage singleMessage : event.getMessage()) {
            if (!(singleMessage instanceof PlainText)) continue;
            sb.append(singleMessage);
        }
        return sb.toString().trim();
    }

    public static Image uploadImage(MessageEvent event, String filename) throws FileUploadException {
        try {
            return ExternalResource.uploadAsImage((File)new File(filename), (Contact)event.getSubject());
        }
        catch (Exception e) {
            throw new FileUploadException("Can not upload the image from the file: " + filename + "\nCause by " + e.getCause().toString());
        }
    }

    public static Image uploadImage(Contact contact, String filename) throws FileUploadException {
        try {
            return ExternalResource.uploadAsImage((File)new File(filename), (Contact)contact);
        }
        catch (Exception e) {
            throw new FileUploadException("Can not upload the image from the file: " + filename + "\nCause by " + e.getCause().toString());
        }
    }

    public static MessageChain buildMessageChain(String ... m) {
        MessageChainBuilder builder = new MessageChainBuilder();
        for (String s : m) {
            builder.append((CharSequence)s);
        }
        return builder.build();
    }

    public static MessageChain buildMessageChain(Object ... m) {
        MessageChainBuilder builder = new MessageChainBuilder();
        for (Object s : m) {
            if (s == null) continue;
            if (s instanceof String) {
                s = new PlainText((CharSequence)s);
            }
            if (s instanceof StringBuilder) {
                s = new PlainText((CharSequence)s.toString());
            }
            if (!(s instanceof SingleMessage)) continue;
            builder.append((SingleMessage)s);
        }
        return builder.build();
    }

    public static List<MessageChain> buildMessageChainAsSingletonList(Object ... m) {
        return OfUtil.ofList(RobotUtil.buildMessageChain(m));
    }

    public static List<MessageChain> buildMessageChainAsList(MessageChain ... m) {
        return OfUtil.ofList(m);
    }

    public static String getSenderId(MessageEvent event) {
        return String.valueOf(event.getSender().getId());
    }

    public static long getSenderId2(MessageEvent event) {
        return event.getSender().getId();
    }

    public static Image uploadImage(MessageEvent event, URL url) throws FileUploadException {
        return RobotUtil.uploadImage(event.getSubject(), url);
    }

    public static Image uploadImage(Contact contact, URL url) throws FileUploadException {
        Image image;
        block8: {
            InputStream stream = IOUtil.sendAndGetResponseStream(url, "GET", null, null);
            try {
                image = Contact.uploadImage((Contact)contact, (InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileUploadException(e);
                }
            }
            stream.close();
        }
        return image;
    }

    public static MessageSource getQuoteSource(MessageEvent event) {
        return Objects.requireNonNull((QuoteReply)event.getMessage().get((MessageKey)QuoteReply.Key)).getSource();
    }

    public static QuoteReply getQuoteReply(MessageEvent event) {
        return new QuoteReply(event.getMessage());
    }

    public static MessageChain quoteReply(MessageEvent event, String msg) {
        return RobotUtil.buildMessageChain(RobotUtil.getQuoteReply(event), msg);
    }

    public static MessageChain quoteReply(MessageEvent event, MessageChain msg) {
        return RobotUtil.buildMessageChain(RobotUtil.getQuoteReply(event), msg);
    }

    public static List<Image> getImagesFromMessage(MessageChain chain) {
        return chain.stream().filter(Image.class::isInstance).map(v -> (Image)v).collect(Collectors.toList());
    }

    public static void sendMsg(List<MessageChain> msg, MessageEvent event) throws CanNotSendMessageException {
        RobotUtil.sendMsg(msg, event.getSubject());
    }

    public static void sendMsg(MessageChain msg, MessageEvent event) throws CanNotSendMessageException {
        RobotUtil.sendMsg(OfUtil.ofList(msg), event.getSubject());
    }

    public static void sendMsg(List<MessageChain> msg, Contact contact) throws CanNotSendMessageException {
        try {
            for (MessageChain chain : msg) {
                contact.sendMessage((Message)chain);
            }
        }
        catch (Exception e) {
            throw new CanNotSendMessageException(e.getMessage());
        }
    }

    public static void sendMsg(MessageChain msg, Contact contact, long autoRecall) throws CanNotSendMessageException {
        try {
            contact.sendMessage((Message)msg).recallIn(autoRecall);
        }
        catch (Exception e) {
            throw new CanNotSendMessageException(e.getMessage());
        }
    }

    public static void sendMsg(MessageChain msg, MessageEvent e, long autoRecall) throws CanNotSendMessageException {
        try {
            e.getSubject().sendMessage((Message)msg).recallIn(autoRecall);
        }
        catch (Exception ee) {
            throw new CanNotSendMessageException(ee.getMessage());
        }
    }

    public static void submitSendRandomMsgTask(String cronExpression, int count, List<String> messages, Contact contact) throws CanNotSendMessageException, SchedulerException, InterruptedException {
        JobDataMap jobData = PeriodCronJob.PeriodCronJobData.getJobDataMap(count, messages, contact);
        RobotCronJob.submitCronJob(PeriodCronJob.class, CronScheduleBuilder.cronSchedule(cronExpression), jobData);
    }

    @Deprecated
    public static void submitSendRandomMsgTask(int hour, int minute, int count, List<String> messages, Contact contact) throws Exception {
        JobDataMap jobData = PeriodCronJob.PeriodCronJobData.getJobDataMap(count, messages, contact);
        RobotCronJob.submitCronJob(PeriodCronJob.class, CronScheduleBuilder.dailyAtHourAndMinute(hour, minute), jobData);
    }

    public static void submitSendRandomMsgTask(final MessageChain msg, final Contact contact, long waitTime) throws CanNotSendMessageException {
        RobotCronJob.service.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    RobotUtil.sendMsg(Collections.singletonList(msg), contact);
                }
                catch (CanNotSendMessageException e) {
                    e.printStackTrace();
                }
            }
        }, waitTime);
    }

    @Deprecated
    public static void submitSendMsgTaskAtFixRate(final MessageChain msg, final Contact contact, long initTTime, long waitTime) throws CanNotSendMessageException {
        RobotCronJob.service.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    RobotUtil.sendMsg(Collections.singletonList(msg), contact);
                }
                catch (CanNotSendMessageException e) {
                    e.printStackTrace();
                }
            }
        }, initTTime, waitTime);
    }

    public static boolean hasQuote(MessageEvent event) {
        return event.getMessage().get((MessageKey)QuoteReply.Key) != null;
    }

    public static MessageChain getQuoteMessageChain(MessageEvent event) {
        return RobotUtil.getQuoteSource(event).getOriginalMessage();
    }

    public static boolean equals(MessageSource source1, MessageSource source2) {
        if (source1 == null && source2 == null) {
            return true;
        }
        if (source1 == null || source2 == null) {
            return false;
        }
        return source1.getFromId() == source2.getFromId() && source1.getTargetId() == source2.getTargetId() && source1.getTime() == source2.getTime();
    }

    @Deprecated
    public static List<MessageChain> doHelp(MessageEvent event) throws MalformedURLException, FileUploadException {
        event.getSubject().sendMessage("\u6b63\u5728\u4e0a\u4f20\u5e2e\u52a9\u56fe\u7247\uff0c\u6b64\u64cd\u4f5c\u53ef\u80fd\u8f83\u6162\uff0c\u8bf7\u7a0d\u7b49\u3002\u5982\u6b64\u64cd\u4f5c\u51fa\u9519\uff0c\u8bf7\u524d\u5f80 https://github.com/happysnaker/mirai-plugin-HRobot \u67e5\u9605\u76f8\u5173\u4fe1\u606f");
        Image image0 = RobotUtil.uploadImage(event, new URL("https://happysnaker-1306579962.cos.ap-nanjing.myqcloud.com/img/typora/image-20220228125440601.png"));
        ArrayList<MessageChain> ans = new ArrayList<MessageChain>();
        ans.add(RobotUtil.buildMessageChain("\u2014\u2014 HRobot v2.0-beta \u2014\u2014\n", image0));
        String desc1 = "\u4ee5\u4e0b\u4e3a\u8868\u683c\u5173\u952e\u5b57\u53ca\u793a\u4f8b\uff0c\u90e8\u5206\u5173\u952e\u5b57\u9700\u8981 @ \u673a\u5668\u4eba\u624d\u6709\u6548\u3002\n\u4e3b\u9875\u5730\u5740\uff1ahttps://github.com/happysnaker/mirai-plugin-HRobot\n";
        Image image1 = RobotUtil.uploadImage(event, new URL("https://happysnaker-1306579962.cos.ap-nanjing.myqcloud.com/img/typora/image-20220228130359523.png"));
        Image image2 = RobotUtil.uploadImage(event, new URL("https://happysnaker-1306579962.cos.ap-nanjing.myqcloud.com/img/typora/image-20220228131341431.png"));
        Image image3 = RobotUtil.uploadImage(event, new URL("https://happysnaker-1306579962.cos.ap-nanjing.myqcloud.com/img/typora/image-20220228131533107.png"));
        ans.add(RobotUtil.buildMessageChain(desc1, image1, image2, image3));
        String desc2 = "\u4ee5\u4e0b\u4e3a\u8868\u683c\u547d\u4ee4\u53ca\u793a\u4f8b\uff0c\u53d1\u9001\u5bf9\u5e94\u547d\u4ee4\u5230\u7fa4\u5185\u5373\u53ef\u8bc6\u522b\uff0c\u547d\u4ee4\u5fc5\u987b\u8981\u4ee5\u7279\u6b8a\u524d\u7f00 # \u5f00\u5934\u3002\n";
        Image image4 = RobotUtil.uploadImage(event, new URL("https://happysnaker-1306579962.cos.ap-nanjing.myqcloud.com/img/typora/image-20220228131050819.png"));
        Image image5 = RobotUtil.uploadImage(event, new URL("https://happysnaker-1306579962.cos.ap-nanjing.myqcloud.com/img/typora/image-20220228131128660.png"));
        Image image6 = RobotUtil.uploadImage(event, new URL("https://happysnaker-1306579962.cos.ap-nanjing.myqcloud.com/img/typora/image-20220228131229491.png"));
        ans.add(RobotUtil.buildMessageChain(desc2, image4, image5, image6));
        String desc3 = "\u5982\u679c\u76f8\u5173 BUG \u6216\u6709\u66f4\u597d\u7684\u521b\u610f\uff0c\u8bf7\u4e8e https://github.com/happysnaker/mirai-plugin-HRobot/issues \u63d0\u51fa\u76f8\u5173 ISSUE\n";
        ans.add(RobotUtil.buildMessageChain(new Object[]{desc3}));
        return ans;
    }
}

