/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StringUtil {
    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static List<String> splitSpaces(String s) {
        ArrayList<String> ans = new ArrayList<String>();
        for (String s1 : s.split("\\s+")) {
            if (s1.isEmpty()) continue;
            ans.add(s1);
        }
        return ans;
    }

    public static String reverse(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = str.length() - 1; i >= 0; --i) {
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static int getEditDistance(String word1, String word2) {
        int i;
        int n1 = word1.length();
        int n2 = word2.length();
        int[][] dp = new int[n1 + 1][n2 + 1];
        for (int j = 1; j <= n2; ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= n1; ++i) {
            dp[i][0] = i;
        }
        for (i = 1; i <= n1; ++i) {
            for (int j = 1; j <= n2; ++j) {
                dp[i][j] = dp[i][j - 1] + 1;
                dp[i][j] = Math.min(dp[i][j], dp[i - 1][j] + 1);
                dp[i][j] = word1.charAt(i - 1) != word2.charAt(j - 1) ? Math.min(dp[i][j], dp[i - 1][j - 1] + 1) : Math.min(dp[i][j], dp[i - 1][j - 1]);
            }
        }
        return dp[n1][n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorInfoFromException(Throwable e) {
        String string;
        PrintWriter pw;
        StringWriter sw;
        block8: {
            sw = null;
            pw = null;
            try {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                string = sw.toString();
                if ($assertionsDisabled || sw != null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    assert (sw != null);
                    assert (pw != null);
                    sw.close();
                    pw.close();
                    throw throwable;
                }
                catch (Exception e1) {
                    e.printStackTrace();
                    return e.getMessage();
                }
            }
            throw new AssertionError();
        }
        assert (pw != null);
        sw.close();
        pw.close();
        return string;
    }

    public static String formatTime() {
        return StringUtil.formatTime(System.currentTimeMillis());
    }

    public static String formatTime(long ts) {
        Date d = new Date(ts);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    public static boolean isNum(String s) {
        s = s.charAt(0) == '-' ? s.substring(1) : s;
        for (char ch : s.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }
}

