/*
 * Decompiled with CFR 0.152.
 */
package com.happysnaker.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Trie {
    private final Map<Character, Trie> children;
    private Trie prevNode;
    private int prefixCount;
    private int fullCount;
    private String val;

    public Trie() {
        this.children = new HashMap<Character, Trie>();
    }

    private Trie(Trie prevNode) {
        this.prevNode = prevNode;
        this.children = new HashMap<Character, Trie>();
    }

    public int getPrefixCount() {
        return this.prefixCount;
    }

    public int getFullCount() {
        return this.fullCount;
    }

    public String getStringVal() {
        return this.val;
    }

    public boolean isStringEnd() {
        return this.fullCount > 0;
    }

    public Trie nextNode(char ch) {
        return this.children.getOrDefault(Character.valueOf(ch), null);
    }

    public Trie getNode(String str) {
        Trie node = this;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (node.children.get(Character.valueOf(ch)) == null) {
                return null;
            }
            node = node.children.get(Character.valueOf(ch));
        }
        return node;
    }

    public void insert(String word) {
        Trie cur = this;
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (cur.children.get(Character.valueOf(ch)) == null) {
                cur.children.put(Character.valueOf(ch), new Trie(cur));
            }
            cur = cur.children.get(Character.valueOf(ch));
            ++cur.prefixCount;
        }
        ++cur.fullCount;
        cur.val = word;
    }

    public void insert(char ch) {
        this.insert(String.valueOf(ch));
    }

    public void delete(String word) {
        Trie node = this.getNode(word);
        if (node == null || node.fullCount == 0) {
            return;
        }
        int i = word.length() - 1;
        int cnt = node.fullCount;
        node.fullCount = 0;
        node.val = null;
        while (node != this) {
            node.prefixCount -= cnt;
            if (node.prefixCount == 0) {
                node.prevNode.children.remove(Character.valueOf(word.charAt(i)));
            }
            --i;
            node = node.prevNode;
        }
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public int search(String word) {
        Trie node = this.getNode(word);
        return node == null ? 0 : node.fullCount;
    }

    public boolean exist(String word) {
        return this.search(word) > 0;
    }

    public int startsWith(String prefix) {
        Trie node = this.getNode(prefix);
        return node == null ? 0 : node.prefixCount;
    }

    public Set<String> getPrefixStringList(String word) {
        Trie node = this;
        HashSet<String> ans = new HashSet<String>(word.length());
        for (int i = 0; i < word.length(); ++i) {
            if ((node = node.nextNode(word.charAt(i))) == null) {
                return ans;
            }
            if (!node.isStringEnd()) continue;
            ans.add(node.getStringVal());
        }
        return ans;
    }

    public Map<String, Integer> getPrefixStringMap(String word) {
        Trie node = this;
        HashMap<String, Integer> ans = new HashMap<String, Integer>(word.length());
        for (int i = 0; i < word.length(); ++i) {
            if ((node = node.nextNode(word.charAt(i))) == null) {
                return ans;
            }
            if (!node.isStringEnd()) continue;
            String key = node.getStringVal();
            ans.put(key, node.getFullCount());
        }
        return ans;
    }
}

